.. _functions:

Functions
=========

RiskScape allows **user defined** Python functions to be used for risk modelling.
For more information, see :ref:`python-functions`.

RiskScape also provides some **built-in** functions for maths, geometry, and
aggregation operations. These built-in functions are listed in the next section.

Functions can be used from any :ref:`RiskScape expression <expressions>`.
This includes both user-defined Python functions and built-in RiskScape functions.
For example, to round a floating point number, you can use the `round` built-in function like `round(-34.23)`.

.. tip::
    Advanced users, who are familiar with the RiskScape expression language,
    can also build their own functions out of RiskScape expressions.
    See :ref:`expression_functions` for more details.

.. _builtin_functions:

## Built-in function reference

RiskScape comes with the following sets of built-in functions that are useful for doing things like mathematics
in the context of RiskScape and Risk Analysis.

.. toctree::
   :maxdepth: 1
   :glob:

   functions/generated/*
   aggregation.md

.. tip::
    You can also see a list of built-in functions available via the CLI.
    For example, to list the maths functions available in RiskScape,
    run ``riskscape function list --category maths``

Where possible, RiskScape makes use of common Java packages that are widely used and
are proven to produce reliable mathematical results.
For example, the `square_root()` RiskScape function is just a simple 'wrapper' for the
Java `Math.sqrt()` function.

## Jython discrete functions

For users defining their own *Jython* functions, RiskScape also makes some maths functionality available
for historic reasons. See :ref:`jython_discrete` for more details.
However, most users will probably find it simpler to use *CPython* and the standard `numpy` or `scipy` libraries.

