
.. _wfs:

# WFS data

[Web Feature Service (WFS)](https://en.wikipedia.org/wiki/Web_Feature_Service) is a way of accessing geospatial data
across the internet.  Using WFS with RiskScape allows you to use data in your models without having
to store it on your computer or in your project.

.. warning::
    The examples on this page use third-party websites that provide freely accessible GIS data via WFS.
    The example URLs are liable to change, which may mean some of the documented example bookmarks no longer work.

.. note::
    WFS servers may require authentication using an access token or a password to access them. We recommend that
    you use the :ref:`secrets_ini` and that you **do not** put authentication secrets directly in to your projects.


## A simple example

Here is a simple example of a WFS bookmark.
This accesses a dataset containing the bus routes in Marlborough.
This dataset was found by browsing the [NZ Open data](https://catalogue.data.govt.nz/dataset/?_res_format_limit=0&res_format=OGC+WFS) website.

```ini
[bookmark Marlborough_bus_routes]
location = https://gis.marlborough.govt.nz/server/services/OpenData/OpenData1/MapServer/WFSServer?request=GetCapabilities&service=WFS
format = wfs
layer = OpenData_OpenData1:Bus_Routes
```

In this case, the WFS server holds multiple `OpenData1` layers, and so we also need to specify the name of the `layer`
that we are interested in as part of the bookmark.

.. tip::
    You can use the WFS URL directly in your models without actually needing to create a bookmark.
    Just like you can use file-paths and bookmark names interchangeably, you can do the same thing with WFS URLs.

### The WFS URL

A WFS URL can contain a long `?KEY1=VALUE1&KEY2=VALUE2` query string, which can be a little confusing.

Typically the WFS URL that you should use in a bookmark will end in `?request=GetCapabilities&service=WFS`.
Sometimes, depending on the WFS server, you can omit this from the URL.
For example, the following bookmark works just as well:

```ini
[bookmark Marlborough_bus_routes]
location = https://gis.marlborough.govt.nz/server/services/OpenData/OpenData1/MapServer/WFSServer
format = wfs
layer = OpenData_OpenData1:Bus_Routes
```

.. note::
    The WFS URL should only contain ``request=GetCapabilities``.
    You do not want the URL to contain any other type of ``request``, e.g. ``request=GetFeature`` will **not** work correctly in a bookmark.

## Troubleshooting

Troubleshooting WFS bookmarks can be a little fiddly.
Here are a few tips.

You should be able to navigate to your WFS server in your web browser.
The content returned by the WFS server will typically be XML, but you can use this to check that you are using the correct HTTP link.
There are some [tips here](https://enterprise.arcgis.com/en/server/latest/publish-services/windows/communicating-with-a-wfs-service-in-a-web-browser.htm)
on how to navigate a WFS server in your browser.

RiskScape provides some commands that help you check that your WFS bookmark is working correctly.
To display a summary of the WFS layer, use the command:

```none
riskscape bookmark info BOOKMARK_NAME
```

You can also download the WFS data into a shapefile on your local file-system using the following command.
You can then open the shapefile to check that the data looks correct.

```none
riskscape bookmark evaluate BOOKMARK_NAME
```

### CRS axis order

It always pays to double-check the axis order that RiskScape uses to load your WFS data.
The `riskscape bookmark evaluate` command can help you do this, by saving the WFS data to a shapefile that you can then open and inspect in QGIS.

The WFS 2.0 specification states that servers should return the data in the axis-order defined by the EPSG definition, which is typically _lat, long_.
However, the WFS 1.0 standard specified that the axis order is _always long, lat_.
To confuse matters, some WFS 2.0 servers can also be configured to *always* return the axis order in _long, lat_.

.. note::
    If the WFS server appears to be returning data in the *long, lat* axis order, then you should use the ``crs-longitude-first = true`` setting
    in your bookmark. You will also need to manually specify the ``crs-name`` when you do this.

### Incomplete results

Some WFS servers have a limit on how many features to return per request, e.g. the `maxRecordCount` setting for ArcGIS servers.
RiskScape will try to detect and use the server's limit when fetching WFS data.

However, RiskScape may not be able to detect this limit for all WFS servers. In this case,
you will get incomplete results when RiskScape loads the WFS data.

.. tip::
  The ``riskscape bookmark info`` command will report a ``Row count`` for your WFS data,
  which is the total number of features loaded.
  If this is a round number (e.g. 1000), then it could indicate incomplete results.

If you suspect that incomplete results have been returned, then try setting the `wfs-page-size` on the bookmark.
The value used should match the limit on the server (typically this would be the current `Row count` for the bookmark).

The `wfs-page-size` specifies the maximum features that will be returned in a single WFS response.
WFS 'paging' means that RiskScape will continue requesting more features until all the data has been returned.

.. _koordinates:

## Koordinates example

Here is a guide to using LINZ data (on the Koordinates platform) via WFS.

1. Follow [these instructions](https://www.linz.govt.nz/data/linz-data-service/guides-and-documentation/creating-an-api-key)
   to create an API key, if you do not have one already.  Make sure you have an entry in your :ref:`secrets_ini` for your LINZ API key.

2. Browse https://www.linz.govt.nz for the map you are interested in.

3. Click on the 'Services' tab.

4. Under the 'Web Feature Service (WFS)' section, there will be an entry like this:

  ```
  The following URL provides WFS capabilities for "YOUR MAP NAME"
  https://data.linz.govt.nz/services;key=YOUR_API_KEY/wfs/LAYER_ID?service=WFS&request=GetCapabilities
  ```

  .. note::
      There are several URLs to choose from here.
      Make sure you pick the URL that contains ``request=GetCapabilities``.

5. Take the `https://` URL and add it to a bookmark in your `project.ini` file.  **Important** - remove the
`;key=YOUR_API_KEY` part, so that you do not accidentally share your LINZ API key with other people that use
your project. Having an entry in your secrets file will ensure your API key gets used in LINZ WFS URLs as needed.

The final bookmark will look something like this:

```ini
[bookmark my_LINZ_data]
# a koordinates secret will be needed for data.linz.govt.nz
requires-secret = koordinates
location = https://data.linz.govt.nz/services/wfs/LAYER_ID?service=WFS&request=GetCapabilities
format = wfs
```

You should now be able to use your bookmark in a model.

## ArcGIS Online

Refer to :ref:`argcgis_wfs` for accessing ArcGIS Online data via WFS.
