
.. _shakemaps:

# USGS ShakeMaps

The US Geological Survey routinely publishes ShakeMaps for significant earthquakes that occur across the globe.
For more details, refer to the [USGS website](https://earthquake.usgs.gov/data/shakemap/)

These ShakeMap files are in HDF5 format, but RiskScape provides a special bookmark format option
that makes these files easier to use in your models.

.. note::
    To use USGS ShakeMaps in RiskScape you will need the :ref:`usgs_plugin` enabled.

## A simple bookmark

To use a USGS ShakeMap in your model, you just need a simple bookmark like the following:

```ini
[bookmark example-shakemap]
location = PATH/TO/shake_result.hdf
format = usgs-shakemap
description = Some details here about the specific quake are probably handy
```

This will load the ShakeMap as :ref:`coverage_ref`, which makes it simple to sample.
This means you can easily use the ShakeMap bookmark as a hazard-layer in your model.

.. tip::
    RiskScape can download remote data via an HTTP link.
    This means the ``location`` in your bookmark could point directly at the ShakeMap download
    link on the https://earthquake.usgs.gov/ website.

When the ShakeMap coverage is sampled (i.e. geospatially matched against an element-at-risk),
it will return the _median_ PGA shaking value at that location in `g` units.

.. note::
    In the ShakeMap file, the PGA values are actually store in ``ln(g)`` units.
    By default, RiskScape will automatically convert the values into ``g`` units,
    because that is usually easier to deal with in your Python function.

## PGA uncertainty

The ShakeMap data contains both the shaking mean and standard deviation for a given location.
The RiskScape bookmark lets you apply some uncertainty to the shaking value you want to use.

For example, instead of using the median value you could use the ninety-fifth percentile.
To do this, simply specify the `percentile` you want to use in the bookmark. For example:

```ini
[bookmark example-shakemap]
location = PATH/TO/shake_result.hdf
format = usgs-shakemap
percentile = 95
```

## Specific datasets

By default RiskScape reads the PGA data for the `GREATER_OF_TWO_HORIZONTAL` Intensity Measure Type
(using both the `mean` and `std` datasets).
However, you can read any dataset in the ShakeMap that you want.

.. note::
    This option is for advanced users who know what they are doing.
    Specifying a ShakeMap ``dataset`` will return that data *as is*.
    RiskScape will not automatically convert from ``ln(g)`` to ``g`` units when
    a ``dataset`` is set in the bookmark.

For example, to read the average MMI data, we simply specify the `dataset` we want in the bookmark:

```ini
[bookmark example-shakemap]
location = PATH/TO/shake_result.hdf
format = usgs-shakemap
dataset = /arrays/imts/GREATER_OF_TWO_HORIZONTAL/MMI/mean
```

Refer to the `units` attribute for the HDF5 dataset as to what units the data values will be returned in.

In your bookmark, you can optionally :ref:`coverage_map_value` to convert from one unit to another.
For example, to convert from `ln(g)` to `g` units, you could add `map-value = exp(value)` to your bookmark.

.. note::
    If you are not interested in the geospatial aspect of the ShakeMap data,
    then you could alternatively read the dataset as relational data.
    Simply changing ``format = usgs-shakemap`` to ``format = hdf5`` will read the
    dataset without including any geometry information.

.
