.. _postgis:

# PostGIS

PostGIS is a PostgreSQL database with spatial extensions installed.
RiskScape can use PostGIS databases for:

- loading input data into a model
- saving the output data, or results, from a model

## Passwords

In most cases, the PostGIS database will require a password to be used.
This password will need to be made available to RiskScape, but this should
be done in a way that will reduce the risk of the password being compromised.

The recommended way to make the password available to RiskScape is to set it
to a `PGPASSWORD` environment variable.
The following examples show you how to set a `PGPASSWORD` environment variable on various operating systems.

### Windows

For Command Prompt:
```none
  set /p PGPASSWORD=Enter you PostGIS Password (check no one is watching):
  cls
```

For Power Shell:
```none
  $ENV:PGPASSWORD = Read-Host Enter you PostGIS Password (check no one is watching):
  cls
```

### Linux

```
  read -sp "Enter you PostGIS Password:" PGPASSWORD
  export PGPASSWORD
```

.. _postgis-location-format:

## PostGIS location format

RiskScape uses a custom location format for PostGIS connections. The format is:
```
  postgis://USER@DB_HOST[:PORT]/DATABASE
```

where:
  - `USER` is the username to connect to the PostGIS database.
  - `DB_HOST` is the host name or IP address of the database host machine.
  - `PORT` optional port to connect to (defaults to 5432).
  - `DATABASE` is the database to connect to.

.. warning::
  Your PostGIS password can also be specified in the bookmark ``location``, however this is not recommended.
  Storing your password in a plain-text file makes it easier for your login credentials to be compromised,
  for example if you share your ``project.ini`` file with other people.

## Bookmarks for input data

A PostGIS table can be used as a RiskScape data source. You can create PostGIS bookmarks
with:

```
[bookmark postgis1]
location = postgis://USER@DB_HOST/DATABASE
layer = TABLE

[bookmark postgis2]
location = postgis://USER@DB_HOST/DATABASE?layer=TABLE
```

.. note::
  Currently the table *must* contain a geometry attribute in order to be used in RiskScape.

## Saving results

RiskScape can also save results to a PostGIS database.
To do this, in the `riskscape model run` command simply specify a PostGIS location for the `--output` CLI option.
E.g `--output postgis://USER@DB_HOST/DATABASE`

.. note::
  Saving results to PostGIS is currently a beta feature.
  You must enable the :ref:`beta-plugin` before you can output results to a PostGIS database.

Saving results to a PostGIS works similarly to saving results to files. The main
difference is that the results are saved into a database table rather than a file.

.. note::
  In order to save results, the database ``USER`` will need to have privileges to create and drop tables in the PostGIS database.
  Dropping tables will occur if you use the ``--replace`` CLI option when running your model.

RiskScape will name the results tables the same way it would name output files.
If the database already contains a table with the output name (e.g `event_loss`) then
the output name will be incremented the same as with files (e.g `event_loss_1`).
However, if the `--replace` CLI option is used, then the existing table is deleted and replaced
with a new one.

.. note::
  When using a PostGIS output, you cannot specify a ``--format`` for the ``riskscape model run`` command.
  Any specified format (e.g ``shapefile``, ``csv`` etc) will simply be ignored.
