.. _settings_ini:

# Settings file

The RiskScape settings file is used to provide extra settings. In some
cases the settings file can be used in place of command line arguments
which is more convenient for settings you want to have applied all the
time.

The RiskScape settings is an INI format file located at:
- `%USERPROFILE%\RiskScape\settings.ini` (Windows)
- `${HOME}/.config/riskscape/settings.ini` (Linux)
- `~/RiskScape/settings.ini` (Mac)

The first time you configure RiskScape settings, you will need to *create* this directory and file.
On Windows, you can do so by entering the following commands into the terminal:

```none
mkdir %USERPROFILE%\RiskScape
notepad %USERPROFILE%\RiskScape\settings.ini
```

.. _settings_plugins:

## Plugins

The settings file can be used to load plugins or even to prevent the
core plugins from being loaded.

```ini
[global]
load-plugin = PLUGIN1
load-plugin = PATH/TO/PLUGIN2

# Uncomment the following line to prevent core plugins being loaded.
#no-core-plugins = true
```

.. note::

  `PLUGIN1` could be the directory name of any :ref:`plugins-default`
  or :ref:`plugins-optional`. E.g ``load-plugin = beta`` would load
  the :ref:`beta-plugin` from :ref:`plugins-optional`.

  `PATH/TO/PLUGIN` is relative to the `settings.ini` file location

