.. _secrets_ini:

# Secrets file

Accessing files on remote servers, such as the [RiskScape Platform](https://riskscape.nz),
may require some form of authentication before you can access it.
RiskScape allows you to provide this information using a secrets file.

The secrets file is kept separate from your project files to make it easy for each
user to have their own secrets and avoid accidentally exposing your secrets as you
share your projects with others.

The RiskScape secrets file is an INI format file located at:
- `%USERPROFILE%\RiskScape\secrets.ini` (Windows)
- `${HOME}/.config/riskscape/secrets.ini` (Linux)
- `~/RiskScape/secrets.ini` (Mac)

.. note::
    Your secrets file should only be readable by you to avoid exposing your secrets to
    others.  `Baeldung <https://www.baeldung.com/linux/chown-chmod-permissions#private-key/>`_
    has some information on how to do this in Linux, but if you can, ask your IT provider
    how best to do this on your computer.

## Authentication Methods

RiskScape supports different kinds of authentication methods, which it terms 'frameworks'.

Which framework you use will depend on what authentication methods the remote service supports.
As an example, the RiskScape Platform supports passing an API token in an HTTP header, so we
can use the `http-header` framework, or the more convenient `platform` framework.

RiskScape currently supports the following authentication frameworks.
Click on a framework below for more details.

.. toctree::
   :maxdepth: 2
   :glob:

   generated/secret-frameworks.md

.. tip::
    When you define bookmarks that require a secret you should set the ``requires-secret`` bookmark
    parameter to the required secret framework. Then if the secret is not found RiskScape can give
    you (or someone you shared the project with) an error telling you exactly what the problem is.

    See :ref:`secrets_platform` below for an example.

## Examples

.. _secrets_platform:

### RiskScape Platform

To be able to work with data stored in a project in the RiskScape Platform, you can use a
[WebDAV token](https://riskscape.nz/docs/tutorials/project-files.html#webdav-access-token).

Follow the link and copy the generated token and paste it in to your secrets file like so:

```ini
[riskscape-nz]
framework = platform
token = YOUR_WEBDAV_TOKEN
```

With this in place, you can access data layers stored in the platform, e.g.

```ini
[bookmark population-grid]
# RiskScape will automatically pass your webdav token when it fetches this data
requires-secret = platform
location = https://riskscape.nz/dav/projects/riskscape/example/getting-started/pop-grid.tiff
```

### Koordinates

[Koordinates](https://koordinates.com) is a cloud geospatial storage service that powers sites such as:

* [LINZ data service](https://data.linz.govt.nz/)
* [Stats NZ data finder](https://datafinder.stats.govt.nz/)

Koordinates uses an API key embedded in a URL to authenticate requests for data. You can
[generate an API key](https://www.linz.govt.nz/data/linz-data-service/guides-and-documentation/creating-an-api-key)
from the specific Koordinates service's user profile menu and then add it to your secrets file.
You then do not need to include your API key in any other project files in order to access the Koordinates datasets.

Here's an example secret that will use the configured API key when fetching WFS data from
`https://data.linz.govt.nz/services`:

```ini
[data.linz.govt.nz]
framework = koordinates
api-key = YOUR_API_KEY
```

For more information on using Koordinates data with RiskScape, via WFS, see :ref:`koordinates`.

.. note::
    RiskScape will add your API key to data service URLs as needed.
    This means that your API key can still potentially appear in debug or error messages.

## When to use secrets

Secrets are currently only supported when using the RiskScape CLI Engine, as they rely on
the `secrets.ini` file to be present on your local computer.
Secrets are intended to be used when fetching remote data via WFS or HTTP links
and using it on your local computer.

When interacting with the RiskScape Platform, secrets can be used on your local computer to fetch data
from the Platform. However, using secrets in projects on the Platform itself is currently not supported.
When uploading a project to the Platform, be careful it does not contain bookmarks
with `require-secrets` set.

.. tip::
    You can take a bookmark that uses secrets and use the following command to turn it into a GeoPackage file:

    ``riskscape bookmark eval BOOKMARK_ID --format geopackage``

    You can then upload the GeoPackage file to the Platform and use that instead of your bookmark.
    Using a local GeoPackage copy of the bookmark may also make your model run faster locally,
    as it avoids fetching the data via WFS each time.

.
