
.. _plugins:

# Plugins

Plugins provide a way of adding new functionality to RiskScape, or extending existing functionality.

RiskScape usually comes with several plugins installed by default. In fact, almost
all of the tools that are required for loss modelling have been added into
RiskScape by plugins.
The RiskScape engine itself simply provides a skeleton framework for building data processing models
that plugins can add to.

This simplified diagram of the software architecture highlights the role that plugins play (click to enlarge it).

.. image:: ../../diagrams/architecture.svg
    :target: ../../_images/architecture.svg
    :width: 60%
    :alt: A simplified software architecture that shows functionality, such as Python support, is provided via RiskScape plugins.

You can see what plugins have been loaded into your version of RiskScape by
running:
```none
  riskscape --version
```

.. _plugins-default:

## Default Plugins

If you have installed RiskScape in the standard location then default plugins are
located at:
- `C:\RiskScape\riskscape\plugins` (Windows)
- `/opt/riskscape/riskscape/plugins` (Linux or Mac)

.. _plugins-optional:

## Optional Plugins

RiskScape comes with some plugins that are optional. Plugins might be optional
because they require some other software to be installed on your computer in order to run.
These plugins could cause errors on startup if the required software is not installed.

Some plugins are optional because they are intended for a very niche use-case, and so they
are not generally applicable to loss modelling.

If you have installed RiskScape in the standard location then optional plugins are
located at:
- `C:\RiskScape\riskscape\plugins-optional` (Windows)
- `/opt/riskscape/riskscape/plugins-optional` (Linux or Mac)

Refer to :ref:`Settings file<settings_plugins>` for how to load plugins.

## Docker

Docker can be a simple way to package and distribute RiskScape to multiple users (within RiskScape's :ref:`licensing terms <license-info>`),
particularly when you want to enable additional plugins by default.

For example, the HDF5 and OGR RiskScape plugins rely on other third-party software components being installed.
Packaging up RiskScape into a docker image means that the dependent components will always be installed correctly and available.

A RiskScape docker image can be manually built from the RiskScape source code by using the `bin/docker-build.sh` script.

.. _beta-plugin:

## Beta plugin

The Beta plugin adds features to RiskScape that may be:

- subject to change
- experimental
- not yet production quality

This plugin is used to make these features available to select users, for testing, whilst preventing
them from being used inadvertently by other users.

.. note::

  When the Beta plugin is enabled you will get a warning on RiskScape started up
  that the plugin has been loaded, and experimental features are available.

.. tip::
    You can use a *separate* ``settings.ini`` to temporarily enable beta features for testing.
    For example, you could create a ``settings.ini`` file in your current working directory
    with the beta plugin enabled, and then load these settings using ``riskscape -H .``
    at the start of your command.

Instead of updating settings files, the Beta plugin can be enabled by using the `--beta` switch
when running RiskScape.  Conversely, if you have it enabled in your settings file, but want to run
RiskScape without the Beta plugin being loaded, you can run RiskScape with `--no-beta`.

### Beta plugin features

#### PostGIS output

This allows RiskScape output to be saved to a PostGIS database instead of files saved to
the file system.

To use specify an output location like: `--output postgis://USER@HOST/DATABASE` and if necessary
set a `PGPASSWORD` environment variable with the database user's password.

RiskScape will create and populate tables in the database with the model run results.

## NetCDF plugin

The NetCDF plugin adds support for opening NetCDF files (i.e. files with a `.nc` file extension).
The NetCDF plugin can be used without installing any other software.
Refer to :ref:`netcdf` for more details.

## HDF5 plugin

The HDF5 plugin adds support for opening HDF5 files (i.e. files with a `.hdf5` file extension).

The HDF5 plugin is dependent on having the [HDF5 library](https://www.hdfgroup.org/downloads/hdf5/)
installed on your system, i.e. the `libhdf5_java.so` library.
Currently RiskScape is supported against HDF5 version 1.12.2.

If this library is installed, but RiskScape cannot find it on your system `PATH` variable, then you could try
adding the following to your :ref:`settings INI file <settings_ini>`.

```ini
[hdf5]
lib_path = <path_to_library>
```

.. _usgs_plugin:

## USGS plugin

The USGS plugin adds support for loading data from :ref:`shakemaps` into RiskScape models.
The USGS plugin also requires that you have the HDF5 library installed and configured on your system
(see previous section).

## OGR plugin

The OGR plugin adds support for extra vector file formats (e.g geodatabase `.gdb`).

The plugin requires separate third-party OGR software to be installed. OGR software is part of
[GDAL](https://gdal.org/index.html).

### Installing OGR

There are two parts to installing OGR for RiskScape. They are:

1. Installing the OGR software
2. Making the OGR software available to the RiskScape plugin

.. note::

  When you next update RiskScape, you will have to make OGR available to RiskScape again,
  i.e. you will have to follow the second half of these steps again. This is because you
  are copying an OGR file into the RiskScape installation directory, and that directory
  will be deleted as part of upgrading.

On an Ubuntu Linux system OGR can be installed with:
```none
  sudo apt-get install -y gdal-bin libgdal-java
  # Now make OGR available to RiskScape
  ln -s /usr/share/java/gdal.jar /opt/riskscape-cli/plugins-optional/ogr/
```

On Windows OGR installation is more complicated.

An OGR installer can be downloaded from [GIS Internals](https://www.gisinternals.com/release.php)
- choose the most recent GDAL version
- choose the compiler/arch that best matches your computer (most likely x64, and the most recent compiler.
I have used GDAL 3.2.1, MSVC 2019 successfully)
- on the next page download `gdal-xxx-xxxx-core.msi Generic installer for the GDAL core components`

Double-click the downloaded `gdal-xxx-xxxx-core.msi` file to install it.
Select the 'Typical' installation. This will install GDAL to
`C:\Program Files\GDAL`

To make OGR available to RiskScape:
- copy `C:\Program Files\GDAL\java\gdal.jar` to `C:\RiskScape\riskscape\plugins-optional\ogr`

On Windows, some environment variables also need to be edited or set in order to use the
downloaded GDAL software. A simple approach is to make this part of the :ref:`Desktop shortcut <shortcut_script>`
that you use to run RiskScape:

```none
cd C:\RiskScape_Projects\

@echo off

set PATH=C:\Program Files\GDAL;%PATH%
set GDAL_DATA=C:\Program Files\GDAL\gdal-data
set PROJ_LIB=C:\Program Files\GDAL\projlib

doskey riskscape=C:\RiskScape\riskscape\bin\riskscape.bat --load-plugin=C:\RiskScape\riskscape\plugins-optional\ogr $*

cmd -c
```

