# Configuring RiskScape

## Projects

Most of the configuration RiskScape uses is specified in a :ref:`project file <projects>`.
The `project.ini` file is like a 'work-space' that tells RiskScape what :ref:`models` it can run,
and what :ref:`functions`, :ref:`Bookmarks <bookmarks>`, and :ref:`types` can be used in the model.

## Settings

The :ref:`settings_ini` can be used to configure *global* RiskScape settings.

The contents of the `project.ini` file will vary depending on what you are modelling,
whereas the `settings.ini` file contains a smaller subset of RiskScape configuration that
will apply *every* time you run RiskScape.

## Secrets

The :ref:`secrets_ini` can be used to configure secrets that can be applied to requests for remote resources.

## Plugins

RiskScape has an extensible architecture. This means you can use :ref:`plugins` to enable or disable
related sets of functionality. By enabling optional plugins you can unlock more RiskScape features,
such as support for NetCDF input data.


.. _multiline-values:

## INI file format

RiskScape uses the [INI file format](https://en.wikipedia.org/wiki/INI_file) with one major
enhancement - it allows for multi-line configuration values using triple quotes.

```ini
[model example]
description = """
This is a
multi-line description
"""
```

Multi-line values are surrounded by three quote characters, using one of `"""`, `'''`, or `` ``` ``.
It makes sense to use a quote character that you're not likely to be using in the string itself.

```ini
[function example]
framework = python
source = '''
def function(exposure, hazard):
  """Python docstrings use triple quotes"""
  pass
'''
```

.. tip:: Multi-line values are particularly useful for :ref:`inline-functions`

### Comments

It is possible to add python-style comments to your configuration files to leave behind
information that is not included as part of the configuration.  Python-style comments
begin with a `#` and stop at the end of the line:

```ini
# An old version of our risk function
[function risk_old]
```

You can also put comments at the end of a line following a section header or a value.
When adding comments at the end of a line, it is important to add a space before the `#`:

```ini
map-attribute.id = OBJECTID # shapefiles always have this
```

Note that previous versions of RiskScape would have included the comment in the
value for `map-attribute.id`.  If you want to include a comment as part of a
configuration value, it's advised that you surround the value in triple quotes:

```ini
map-attribute.construction_type = '''
  # this expression calls a function to map the type
  if(const_type == 'wood',
  ...
'''
```

### Unsupported INI features

RiskScape's INI parser does not support:

- Using `:` as a key/value separator, e.g. `type: text` - this needs to be separated with an equals sign, e.g. `type = text`
- Space separated key/value, e.g. `type text` - this also needs to be separated with an equals sign, e.g. `type = text`

If you have used this format with your project files in the past, due to changes in RiskScape's INI
parser, you may now get an error that looks something like:

```
Problems found with --project
  - Problems found with 'file:/Projects/getting-started/project.ini' config
    - Unexpected character 'd' at line 4, column 1
```

If you get an error like this after upgrading RiskScape, you may be using a no longer supported
key/value format.  You can either update your project files to use `=` as a separator (as above)
or enable the legacy parser by adding the following to your :ref:`settings_ini`:

```
[engine]
use-legacy-ini = true
```

.. warning:: Using the legacy parser will disable new features like source locations in error messages and multi-line configuration values.
