.. _aggregation:

## Aggregation

RiskScape can aggregate individual results into more meaningful information.
For example, instead of reporting each individual damaged building, RiskScape can report a total count of damaged buildings.

To produce an aggregated result, you need to use an _aggregation expression_, which has the form:

```none
aggregation-function(attribute-to-aggregate) as new-name
```

For example, `max(hazard) as Max_flood_depth` or `sum(consequence.loss) as Total_loss` are simple aggregation expressions.
Refer to :ref:`expressions` for more details on what expressions are. 

Aggregation expressions are used in the `group` :ref:`pipeline <pipelines>` step.
The `group` step also specifies the attribute to group the results _by_.
For example, to see the results broken down based on a building's construction type,
you might group by the `exposure.construction` attribute.

Results can also be aggregated spatially, such as producing a total count for each regional territory.
Spatial aggregation is done by using an _area-layer_ in your model and then grouping by `area.name`.

.. _aggregate_functions:

### Built-in aggregation functions

The following functions are built into RiskScape:

* `count`
* `max`
* `mean`
* `median`
* `min`
* `mode`
* `percentile`
* `stddev` (Standard Deviation)
* `sum`

For more information on a particular function, enter the `riskscape function info <function-name>` command.


