.. _upgrade:

# Upgrading RiskScape

If you already have RiskScape installed on your system,
here's how to upgrade the software to a more recent version.

.. warning::
  To upgrade RiskScape you must first **remove** your current copy.
  Simply extracting a new version of ``riskscape.zip`` over the top of an
  existing version may result in errors or unexpected behaviour.

.. note::
  RiskScape requires that Java version 17 (or higher) is installed on your computer
  in order to run.

## Replace the old installation directory

First, work out the directory location where RiskScape is already installed.
If you cannot remember the installation location, try one of the following:

1. If you have added `riskscape` to your system `PATH`, then you can use:  

  * `get-command riskscape.bat` on Windows (PowerShell).
  * `where riskscape.bat` on Windows (Command prompt).
  * `which riskscape` on Linux or Mac.

  For example:
  ```text
  C:\Users\demo> where riskscape.bat
  C:\RiskScape\riskscape\bin\riskscape.bat
  ```

2. Or, if you use a :ref:`shortcut_script` to run RiskScape, right-click on the shortcut and click 'Edit'.  
The RiskScape installation directory will be on the `doskey` line (or `Set-Alias` for PowerShell). E.g.

  ```text
  doskey riskscape=C:\RiskScape\riskscape\bin\riskscape.bat $*
  ```

In these examples, `C:\RiskScape` is our installation directory, and everything under that
was extracted from the `riskscape.zip` file previously.

Rename the existing `riskscape` directory, e.g. to `riskscape-old`.
A good approach is to rename it `riskscape-vX.Y.Z`, where `X.Y.Z` matches the version number
in your current `riskscape --version` output.
For example:

```text
C:\Users\demo> cd C:\RiskScape
C:\RiskScape> move riskscape riskscape-v0.5.5
```

.. tip::
  Although you could simply delete the old ``riskscape`` directory,
  renaming it is better, as you can still run older versions of RiskScape
  easily if needed. This ensures reproducibility of your model's results,
  i.e. you can regenerate results with *exactly* the same software as used
  in a publication.

## Install the new RiskScape Zip file

Download the latest :ref:`RiskScape zip file <downloads>`
and extract the contents into your installation directory, e.g. `C:\RiskScape`.

Open a terminal prompt and check that RiskScape still works, and is now the expected version.
You may want to try the full executable path first, as a sanity-check. E.g.
```text
C:\RiskScape\riskscape\bin\riskscape.bat --version
riskscape --version
```

## Trouble-shooting

If the shorter `riskscape` command does not work, your installation directory path
may have changed slightly.

If you are using a :ref:`Windows shortcut script <shortcut_script>`,
then check that the shortcut still points to where you installed RiskScape.
You could try creating the shortcut again.

If you do not use a Windows shortcut, then check your `PATH` environment variable
contains the `bin/` directory for the RiskScape installation.
E.g.
* `echo %PATH%` on Windows
* `echo $PATH` on Linux or Mac

Refer to the :ref:`installation instructions <installation>` on how to set `PATH`.

