.. _recap_intro:

# Recapping the basics

Once you have been through the introductory tutorials (:ref:`getting-started`, :ref:`wizard-how-to`, and :ref:`project-tutorial`) you will have learnt how to build models that identify elements-at-risk that were exposed to a hazard.

These tutorials cover a lot of material on things you _might_ need to know about RiskScape modelling. However, you don't have to understand _everything_ covered in order to do simple modelling in RiskScape. This page is a recap on the basics required to put a simple model together.

If you are comfortable with the concepts on this page, you could try :ref:`intermediate_models`.

## General

When you install RiskScape, make sure that the `riskscape` executable is added to your `PATH`.
Windows users might want to use a :ref:`Desktop shortcut <shortcut_script>` to do this.
* You run RiskScape from a terminal (on Windows this will be the Command Prompt or PowerShell).
* Use `riskscape --version` to sanity-check you can run RiskScape successfully.
* It pays to always run the most recent version of RiskScape.

If you forget the exact RiskScape command to run, you can use `riskscape --help`, or add `--help` to the end of any `riskscape` command, to find out more.

Always run RiskScape commands from the directory containing your `project.ini` file.
* Use the `cd` command to change to the correct directory.
* Use the `dir` (Windows) or `ls` (Linux or Mac) commands to check what files are present (you should see a `project.ini` file in the output).

## To run a model

To run a saved model, use the `riskscape model run MODEL_NAME` command.

To see the names of your saved models, as well as what model parameters they use, enter the `riskscape model list` command.

To change a model parameter on the fly, use the `--parameter`  or `-p` CLI option on the end of the `riskscape model run` command. This is in the format `-p "PARAMETER_NAME=NEW_VALUE"`.

Typically you might want to run the same model against different hazard-layers. To change the hazard-layer input used by your model, use:
```
riskscape model run MODEL_NAME -p "input-hazards.layer=MY_HAZARD.tif"
```

## To create a project

You need to create a `project.ini` file before you can build a model.
Try using the following template:

```ini
[project]
auto-import = true

[bookmark exposure_layer]
location = MY_BUILDINGS.shp

[bookmark hazard_layer]
location = MY_HAZARD.tif

[bookmark area_layer]
location = MY_REGIONS.shp

# function is optional - you could just use the built-in is_exposed function
[function exposure_status]
location = exposure_status.py
argument-types = [ building: anything, hazard: nullable(floating) ]
return-type = text
```

A simple example of a Python function (i.e. `exposure_status.py`) that you could modify to suit your model.

```python
def function(building, hazard_depth):
    if hazard_depth is None or hazard_depth <= 0:
        return 'Not exposed'

    if hazard_depth > 2.0:
        status = 'Exposure >2.0m'
    elif hazard_depth > 1.0:
        status = 'Exposure >1.0m to <=2.0m'
    else:
        status = 'Exposure >0.0m to <=1.0m'

    return status
```

Replace the file locations with the input data you want to use.
Make sure you save the file as `project.ini` and not `project.ini.txt`.

## To build a model

To build a model, use the `riskscape wizard` command. At the end of the wizard, save the model so you can run it again later. To start with, we recommend choosing 'closest' sampling - it's the simplest spatial sampling option.

The RiskScape wizard requires that bookmarks are present. But everywhere else you can usually use files directly instead of a bookmark. This works for shapefiles, GeoTIFF, GeoJSON, and ESRI grid (`.asc`).

Remember that you can build projects and models and then _share_ these projects with other people.
A user doesn't necessarily need to know all the ins and outs of model building in order to _run_ a RiskScape model.





