.. _overview:

# Overview

## What is RiskScape?

RiskScape is an open-source spatial data processing application used for multi-hazard risk analysis.
RiskScape is highly customizable, letting modellers tailor the risk analysis to suit the problem domain and input data being modelled.

RiskScape can bring together input data from a wide range of different formats
and apply a variety of geospatial, statistical and data manipulation operations.
This lets users model a variety of workflows in a consistent way,
while simplifying the complexities (and quirks) of working with geospatial data.

The RiskScape software supports highly-parallelized processing of datasets,
making RiskScape suitable for a variety of deployments, from running simple deterministic models on a laptop
through to running computationally-intensive probabilistic models on a high-end cloud computing instance.

RiskScape gives you the power to define your own risk analysis calculations
to aid in decision making, policy and planning decisions,
and help better mitigate risk from natural and human-made hazards.

## What does RiskScape do?

RiskScape provides a flexible data processing framework for analysing geospatial risk models.

RiskScape takes a variety of input layers and geospatially stitches them together.
For example, RiskScape can take a building portfolio and a flood hazard map and tell you the
flood depth (if any) that each building was exposed to.

You can provide your own Python function that RiskScape will use to compute the impact (e.g. repair cost)
or analyse the consequence that the flood has on each building individually.

RiskScape can then collate the results, such as summing the losses for buildings located in a particular region.

Visualized, the workflow for this simple example model would look like this:
[comment]: <> (Styling for all mermaid diagrams are classes, check for details -> custom.css)
.. mermaid::

    graph LR

      EL("Building<br/>Data");
      HL("Flood map");

      GS("Geospatial<br/>matching");
      EL --> GS;
      HL --> GS;
      PY("Python<br/>function");
      GS --> CA("Analyse<br/>consequences");
      PY -.-> CA;
      CA --> REP("Report<br/>collated<br/>results");

      %% Styling
      class EL,HL rs-box-navy
      style EL color:#FFF
      style HL color:#FFF
      class CA,GS rs-box
      class REP rs-box-green
      class PY rs-box-optional


RiskScape supports a variety of input and output file formats, and can be used to evaluate the impacts of
any geospatial hazard (or combination of hazards), such as flood, earthquake, tsunami, volcanic eruption, landslide, sea level rise, or cyclone.

RiskScape provides a well-defined model workflow that suits most exposure and deterministic models,
but also provides the flexibility to build more complex probabilistic models from scratch.

## How does it work?

RiskScape provides a wizard to help users build a simple risk model initially,
by answering a series of questions relating to their input data and what is being modelled.

Underneath the hood, RiskScape uses its own scripting language to describe the model's processing workflow as what is called a _pipeline_.
A pipeline simply defines a series of data processing steps, written as simple expressions that are similar to spreadsheet formula or basic Python statements.

When RiskScape runs a wizard model, it takes the wizard answers and automatically turns them into pipeline code that it can then execute.

As modellers become more advanced RiskScape users, they can completely customize their modelling workflow by defining it directly in pipeline code,
using the pipeline code generated by a wizard model as a starting point.

Currently the open-source RiskScape Engine is a CLI tool, which means users 'run' their models from the command-line.
Running a model means RiskScape executes the underlying data processing pipeline, i.e. reading
in the input data, processing it as instructed, and saving the results to file.

Models support parameters, which allows you to re-run a model whilst varying the input data files or other assumptions that the model makes.

.. mermaid::


    graph LR
      WIZ("Wizard answers");
      DSL("Customized<br/>pipeline code");
      MODEL("Risk Model");
      WIZ -- Beginners --> MODEL;
      DSL -- Advanced --> MODEL;
      PARAMS("Parameters<br/>to vary") -.-> MODEL;
      MODEL --> PIPE("Pipeline<br/>to execute");

      %% Styling
      class PARAMS rs-box-optional
      class DSL,WIZ,MODEL,PARAMS,PIPE rs-box

The details of the models and pipelines are stored in plain-text files (e.g. [INI files](https://en.wikipedia.org/wiki/INI_file))
that tell RiskScape exactly what to do. This collection of files is called a _project_.
The project defines the model workflows from start to finish, including which input data files and vulnerability functions should be used.

## What are projects for?

:ref:`projects` are a way to organize your RiskScape models so that related models are grouped together in a sensible way,
i.e. models that involve related hazards, and that affect the same features of interest, are kept in the same project.

A project contains the complete set of RiskScape instructions required to run one or more models.
This can include:

- **Input data sources**:
  Data from various popular GIS sources can be used, without needing to be imported or pre-processed.
  The locations of the various input files, as well as any additional instructions on how to load the data,
  is specified in what is called a RiskScape :ref:`bookmark <bookmarks>`.
- **Functions**:
  Users can write their own :ref:`functions <functions>` in Python to assess the impact a hazard has on an element-at-risk,
  such as estimating damage, calculating costs, or sampling a probabilistic curve.
  Advanced users can also use functions to manipulate or transform the data at any point in the pipeline.
- **Types**:
  RiskScape uses a :ref:`type <types>` system to represent the structure of the data as it flows through the model.
  Types constrain how the input data can be manipulated, such as what functions can be used.
  Compound types can represent a set of attributes, such as a building asset or the consequence (losses, damage, etc) from the hazard.
- **Models**:
  The :ref:`model <models>` is the combination of input data, functions, and other parameters that are applied
  to a data processing pipeline to produce results. Models can be defined from saved wizard answers or
  can be defined directly in pipeline code.

The project contains all the components, which when put together, result in executable model pipelines.

.. mermaid::

    graph TD
     subgraph Input data source
      WFS("WFS/WCS");
      FILES("Shapefiles, Rasters, CSV");
      POSTGIS("PostGIS");
      BOOKMARKS("Bookmarks");
      end
      TYPES("Types");
      WFS --> BOOKMARKS;
      FILES --> BOOKMARKS;
      POSTGIS --> BOOKMARKS;
      FUNCTIONS("Functions")
      TYPES -.-> BOOKMARKS;
      TYPES -.-> FUNCTIONS;
      MODELS("Models");
      FUNCTIONS --> MODELS;
      BOOKMARKS --> MODELS;

      %% Styling

      class WFS,FILES,POSTGIS,FUNCTIONS,BOOKMARKS rs-box-navy
      style WFS color:#FFF
      style FILES color:#FFF
      style POSTGIS color:#FFF
      style FUNCTIONS color:#FFF
      style BOOKMARKS color:#FFF
      class TYPES rs-box-optional
      class MODELS rs-box-green


## How do I get started?

Follow the :ref:`installation` guide to install RiskScape on your system.

Then follow the :ref:`getting-started` tutorial to get a feel for running a basic model in RiskScape.
