# Advanced installation tips

.. note::
    This page contains alternative installation tips for **advanced** users.
    Most users should try following the standard :ref:`installation` instructions first.

.. _set_PATH_Windows:

## Update PATH on Windows

Windows users can set the system `PATH` environment variable,
the same as Linux or Mac users.
This is an alternative, instead of creating a :ref:`shortcut_script`.

.. note::
    Editing the ``PATH`` can be a little tricky to get right, and it can **break**
    existing software if you get it wrong.
    The command provided here is only an example - it is not guaranteed to be correct
    for your version of Windows.

To set the `PATH` on Windows:

1. Click on the Windows Start menu.

2. Start typing 'command'.

3. Right click on the 'Command Prompt' application and select 'Run as Administrator'.

4. Enter a command like the following to change the `PATH` permanently.
  ```none
  setx PATH "%PATH%;C:\RiskScape\riskscape\bin"
  ```

.. tip::
    If you do not have administrator privileges, or would prefer not to permanently alter your ``PATH``
    setting, you can :ref:`Desktop shortcut <shortcut_script>` instead.

.. _powershell_shortcut:

### PowerShell shortcut

This is an alternative for users who prefer the PowerShell prompt.
Otherwise, you can skip this section.

To create a PowerShell Desktop shortcut for RiskScape:

1. Create a top-level directory to keep your RiskScape projects in, if needed, e.g. `C:\RiskScape_Projects\`.

2. Open Notepad.

3. Paste in the following. Adjust the `$env:Path` line to match your installation directory.

    ```text
    cd C:\RiskScape_Projects\

    $env:Path += ';C:\RiskScape\riskscape\bin'

    powershell
    ```

4. Save the file to your desktop as `RiskScape Shortcut.ps1`.
Make sure you change 'Save as type' to 'All files'.

5. Test the shortcut works. Go to your desktop, right-click on it and select 'Run with PowerShell'.  
A PowerShell prompt should open. Type `riskscape --help` and check it works.

