.. _cli-help:

# How to navigate the RiskScape CLI

RiskScape uses similar conventions to other Linux-based command-line utilities.
If you are not familiar with using CLI (Command Line Interface) tools,
this page has some tips on getting started.

## It's OK to ask for help

All RiskScape CLI commands include some basic help to point you in the right direction.
You can *always* access this help by adding `--help` or `-h` to the end of your command. E.g.

```none
riskscape -h
```

If you forget how to access the help, you can just type `riskscape` on its own
and it will display the same basic help message.

Running `riskscape --help` outputs a lot of information.
We'll go through and break down what this all means in more detail.
First, let's look at RiskScape's *sub-commands*.

## Sub-commands

The RiskScape CLI actually consists of many different sub-commands.
Each sub-command achieves a different aim.

Most RiskScape sub-commands boil down to the syntax: `riskscape <thing> <action> [options]`.
For example, to run a model you would use `riskscape model run`.

Common sub-command *actions* are:
* `list`: Output a list of all the *things* available.
* `info <name>`: Provide more help information about one specific *thing*.
* `run <name>`: Performs the specific *thing* you asked it to do.

For models, `riskscape model list` will tell us what models are available for us to run.

For the *thing*-part of the sub-command, some frequently used options are:
* `bookmark` for :ref:`bookmarks`.
* `type` (user-defined) and `type-registry` (built-in) for :ref:`types`.
* `function` for :ref:`functions`.
* `expression` (or `expr`) for :ref:`expressions`.
* `model` for basic risk :ref:`models`.
* `pipeline` for advanced risk modelling by expert users.

### Navigating sub-commands

Each sub-command has its own help message.
So you can start typing out a RiskScape sub-command and use `--help` to gradually drill-down
to the actual command to use.

To start with, running `riskscape --help` lists all the available command key-words that we can specify next. E.g.

```none
...
Commands:
  bookmark          List and inspect bookmark data
  function          Query available functions (built-in or user-defined)
  model             Run and list framework-based models
  type              Query user-defined types
  type-registry     Query built-in types available
  resource-loader   Query ways that resource files can be loaded into RiskScape
  pipeline          Inspect and run pipelines
  expression, expr  Test and debug RiskScape expressions
  i18n              Internationalisation features
  wizard            Run the interactive 'wizard' for constructing a risk model
                      processing pipeline
```

This is the *thing* part of the sub-command.
In this case, the thing we're interested in is models, so let's try running `riskscape model --help`.

```none
...
Usage: riskscape model [COMMAND]
Run and list framework-based models
Commands:
  list       List models that exist in your project
  run        Run a model, save results
  batch      Run a model repeatedly, varying one parameter each time
  framework  Query the model frameworks that can be used to define a model
```

This is the *action* part of the sub-command.
In this case, we just want to run a basic model once, so let's try `riskscape model run --help`.

```none
Usage: riskscape model run [-hr] [--checksum] [--no-progress-indicator]
                           [--print] [-f=<format>] [-o=<outputDir>]
                           [--parameters=<parametersFile>] [-p=<parameters>]...
                           <modelId>
Run a model, save results
      <modelId>              ID of the model to run. See `model list` for
                               possible choices
      --checksum             Produce checksums for model output based on the
                               model input
  -f, --format=<format>      Set an output file format to take effect when no
                               format has been specified in the model itself.
                               See `riskscape format list` for supported formats
  -h, --help
      --no-progress-indicator
                             Do not output progress monitor
  -o, --output=<outputDir>   Save the model results as files in the specified
                               location. By default, results are saved in a
                               `<projectOutputDirectory>/<modelId>/<timestamp>`.
                                `<projectOutputDirectory>` can be set in the
                               project.ini file but defaults to a directory
                               called `output` beside the project file. When an
                               output location is supplied, these extra
                               sub-directories are omitted. Any existing
                               results in the output location will not be
                               overwritten unless `--replace` is used. Instead,
                               the file name will be incremented, e.g.
                               event-impact-1.csv, event-impact-2.csv
  -p, --param, --parameter=<parameters>
                             Supply parameters to the model in the format
                               key=value, e.g. `-p asset=path-to-assets.shp`.
                               Give the name alone to clear a parameter, i.e
                               `-p name` would clear the value set for the name
                               parameter.  Parameters supplied via
                               `--parameter` take precedence over any model
                               supplied defaults and any values supplied via
                               `--parameters`.
      --parameters=<parametersFile>
                             Supply parameters to the model in an INI formatted
                               file.  Similar to `--parameter`, but allows many
                               parameters to be set at once.  Parameters are
                               read from a single INI section (if the file only
                               has one section), or an INI section with the
                               same name as the model being run.  Parameters
                               supplied via `--parameters` take precedence over
                               any model supplied defaults, but not over any
                               supplied via `--parameter`.
      --print                Print the realized pipeline without executing it.
                               Useful for trouble-shooting
  -r, --replace              When an output location is specified, this will
                               replace any existing files with the new results,
                               i.e. any previous results in the output location
                               will be overwritten.
```

We now have a full sub-command we can run.
This time, the `--help` lists all the options available for this command.
Let's examine this output in more detail.

## Usage
The first part of the help command gives an example of the *usage*. This is a
short summary of all the acceptable input for this command.

```none
Usage: riskscape model run [-hr] [--checksum] [--no-progress-indicator]
                           [-f=<format>] [-o=<outputDir>]
                           [--parameters=<parametersFile>] [-p=<parameters>]...
                           <modelId>
...
```

To decipher this output, you need to know that:
* The square brackets (`[]`) mean that something is *optional* and so it doesn't
*have* to be specified.
* The angle brackets (`<>`) denote placeholders that you need to replace with
your own input. E.g. for `<modelId>` you might specify the `default` model template.
* The ellipsis indicates that the option that can be specified multiple times.
E.g. `--parameter=p1=value1 --parameter=p2=value2`.

## CLI Options

The second part of the help output displays the same usage options but in more detail.

```none
...
Run a model, save results
      <modelId>              ID of the model to run. See `model list` for
                               possible choices
      --checksum             Produce checksums for model output based on the
                               model input
  -f, --format=<format>      Set an output file format to take effect when no
                               format has been specified in the model itself.
                               See `riskscape format list` for supported formats
  -h, --help
      --no-progress-indicator
                             Do not output progress monitor
  -o, --output=<outputDir>   Save the model results as files in the specified
                               location. By default, results are saved in a
                               `<projectOutputDirectory>/<modelId>/<timestamp>`.
                                `<projectOutputDirectory>` can be set in the
                               project.ini file but defaults to a directory
                               called `output` beside the project file. When an
                               output location is supplied, these extra
                               sub-directories are omitted. Any existing
                               results in the output location will not be
                               overwritten unless `--replace` is used. Instead,
                               the file name will be incremented, e.g.
                               event-impact-1.csv, event-impact-2.csv
  -p, --param, --parameter=<parameters>
                             Supply parameters to the model in the format
                               key=value, e.g. `-p asset=path-to-assets.shp`.
                               Give the name alone to clear a parameter, i.e
                               `-p name` would clear the value set for the name
                               parameter.  Parameters supplied via
                               `--parameter` take precedence over any model
                               supplied defaults and any values supplied via
                               `--parameters`.
      --parameters=<parametersFile>
                             Supply parameters to the model in an INI formatted
                               file.  Similar to `--parameter`, but allows many
                               parameters to be set at once.  Parameters are
                               read from a single INI section (if the file only
                               has one section), or an INI section with the
                               same name as the model being run.  Parameters
                               supplied via `--parameters` take precedence over
                               any model supplied defaults, but not over any
                               supplied via `--parameter`.
      --print                Print the realized pipeline without executing it.
                               Useful for trouble-shooting
  -r, --replace              When an output location is specified, this will
                               replace any existing files with the new results,
                               i.e. any previous results in the output location
                               will be overwritten.
```

This output includes:
* The CLI flag to use.
Note that some options have both a *short* (e.g. `-o`) and *long* (e.g. `--output`) alternative.
* What other information needs to be provided when using the option.
E.g. `--output` needs to be followed by an output file path,
whereas `--print` can be specified on its own.
* A brief description of what the option actually does.

## Common CLI options

Some CLI options are common to all RiskScape commands.
These options need to be specified directly after the `riskscape` command
and before any other options.
E.g. `riskscape [common-options] model run [sub-command-options]`.

Examples of common options:
* Specifying a project file (`--project`).
This is where RiskScape will try to load all your types, functions, and bookmarks from.
* Show all errors for your project (`--show-project-errors`).
  When something in your project is misconfigured (e.g. trying to use a file that doesn't exist),
  RiskScape won't display detailed error information by default until you actually try to use the broken thing.
  Instead it gives you a summary message like:
  ```text
  There were 2 problem(s) during engine initialization, run riskscape with --show-project-errors for more details
  ```

  This avoids noise when you have cascading problems - for example, one broken thing that gets used by many different models.

* Show more detailed information when an unexpected error occurs (`-e` or `--show-stacktrace`).
* Increase the detail logged (`--log-level`).
* Seed the random-number generation (`--random-seed`), for reproducible results
when randomness is involved.

These common options are displayed in the `riskscape --help` output.

### Software version

The `riskscape --version` command will tell you the exact version of RiskScape you're using.
Try running it now.

Knowing the version you have got is helpful when deciding whether to upgrade RiskScape.
New features and bug fixes will become available as new RiskScape versions are released.
For example, if you are using older software and encounter a bug, it's possible that
the problem has already been fixed in a more recent version.

If a bug is not fixed in the latest RiskScape software, please report the problem.
Refer to :ref:`reporting-bugs` for more details.

## Exploring the CLI yourself

Try exploring the RiskScape CLI yourself, using the `--help` option.
See if you can do the following:

* List the built-in types available.
* Display detailed information for the 'default' model template.
* List the built-in maths functions available.

As you get more familiar with the command prompt, you may find it helpful
to run other OS commands too, for example to check output files. Here are some
[common shell commands](https://www.linuxtopia.org/online_books/redhat_linux_step_by_step_guide/ap-doslinux.html).

