.. _contact:

# Contact RiskScape

Please address your query to the appropriate place.

## Software questions

If you have a technical question about how to use a RiskScape command or feature,
please visit https://community.riskscape.org.nz

.. tip::
    Please check that someone else hasn't already asked the same question as you before posting.

## New releases

To stay informed of new RiskScape releases, please subscribe to notifications in the _Announce_ category in https://community.riskscape.org.nz.
This is a low-volume mailing list where you will receive updates as new RiskScape software releases become available.

To subscribe:
1. Go to the [Announcements category](https://community.riskscape.org.nz/c/announcements)
2. Change your Notifications setting from 'Normal' to 'Watching' - press the bell button on the right-hand side, next to 'New Topic',
   to find these settings.

## Science and terms of use

Please contact [Earth Sciences New Zealand](https://www.earthsciences.nz/contact-us)
if you have a question regarding:

- the scientific applications of using RiskScape for the risk analysis of hazards.
- the :ref:`licensing terms <license-info>` under which RiskScape can be used, e.g. you are interested in using RiskScape for commercial purposes.
- getting paid support for your RiskScape project.
- getting access to the RiskScape docker image.

.. _reporting-bugs:

## Reporting bugs

Bugs can be reported to riskscape-dev@catalyst.net.nz. Please include the following:

- `riskscape -V` output
- The command you were running.
- What you _expected_ to happen.
- What _actually_ happened. Please include any error messages or stack-traces in full.
- Please re-run the problematic RiskScape command with the `--show-project-errors` and `--show-stacktrace` options specified after the `riskscape` command. For example:

    ```none
    riskscape --show-project-errors --show-stacktrace model run your-model
    ```

