.. _dev-how-to:

# RiskScape developer guide
​
This assumes that you already have the source code for RiskScape on your machine.

.. note::
    This guide is intended for developers using a Linux-based operating system, such as Ubuntu.

## Prerequisites

### Java 17

.. note::
    Building RiskScape will rely on Java 17 being set as your default JDK.
    If you cannot install Java 17, you can still use docker to build the RiskScape code -
    just use the ``./bin/docker-gradle.sh installdist`` command to build RiskScape instead of ``./gradlew installdist``.
​
The following section will setup Java 17 on your system and is based on the [instructions here](https://docs.datastax.com/en/jdk-install/doc/jdk-install/installOpenJdkDeb.html).

First, start by checking with version you're running:
```none
java -version
```

If you are already using Java 17, then it should look something like this:

```none
java -version
openjdk version "17.0.6" 2023-01-17
OpenJDK Runtime Environment (build 17.0.6+10-Ubuntu-0ubuntu120.04.1)
OpenJDK 64-Bit Server VM (build 17.0.6+10-Ubuntu-0ubuntu120.04.1, mixed mode, sharing)
```

If your default Java is a different version, follow these instructions to install the Java 17 JDK.

1. Make sure the Java 17 OpenJDK is installed on your machine:  

    ```none
    sudo apt-get update
    sudo apt-get install openjdk-17-jdk
    ```

2. Run the following command and set Java 17 as your default Java version.  

    ```none
    sudo update-alternatives --config java
    ```

.. tip::
    To remove unnecessary older Java versions, refer to the `instructions here <https://novicestuffs.wordpress.com/2017/04/25/how-to-uninstall-java-from-linux/>`_.

### GIS file viewer

While not _strictly_ necessary for development, we recommend that you have a GIS application installed
that will allow you to view shapefile and GeoTIFF files.
For example, [QGIS](https://qgis.org/en/site/) can be installed by running:

```none
sudo apt-get install qgis
```

## Installing RiskScape

### Building the code

To build RiskScape run the following command:

```none
./gradlew installdist
```

This will produce a `riskscape` executable in the `engine/app/build/install/riskscape/bin/` sub-directory.

### Adding RiskScape to your PATH

1. Make a note of the full file path to your `riskscape` executable.
For example, if your git repository is `~/code/riskscape`, then your RiskScape executable will be
`~/code/riskscape/engine/app/build/install/riskscape/bin/riskscape`.

2. Open your `~/.bashrc` file in a text-editor. Add the following line to the `.bashrc` file, replacing the file path with the directory obtained in step 1:

    ```
    PATH=$PATH:~/code/riskscape/engine/app/build/install/riskscape/bin
    ```

3. Close and re-open your bash terminal, so that the `PATH` change takes effect.

4. Check that RiskScape is now visible on your `PATH` by running `riskscape --version`.
The output should be similar to the following:

```none
RiskScape Core Engine v1.4.0-dev
--------------------------------
Build time - Wed Mar 01 11:28:55 NZDT 2023
Git SHA1   - 827ba33e4e1e2651b81fc6580aa4a645617de55b

Plugins:
defaults     1.4.0-dev  nz.org.riskscape.engine.defaults.Plugin
postgis      1.4.0-dev  nz.org.riskscape.postgis.Plugin
wizard       1.4.0-dev  nz.org.riskscape.wizard.WizardPlugin
wizard-cli   1.4.0-dev  nz.org.riskscape.wizard.WizardCliPlugin
jython       1.4.0-dev  nz.org.riskscape.jython.Plugin
cpython      1.4.0-dev  nz.org.riskscape.cpython.CPythonPlugin

System:
Linux 5.15.0-60-generic
Java 17.0.6 OpenJDK 64-Bit Server VM 17.0.6+10-Ubuntu-0ubuntu120.04.1
```

.. tip::
    Check the ``Build time`` timestamp in the first line matches when you built RiskScape.

### Troubleshooting

If you get an error when you run RiskScape about the `JAVA_HOME` environmental variable being set incorrectly,
then you will need to update it. This may happen if you already had a different JDK version installed.
To update the `JAVA_HOME` variable, run the following command:

```none
export JAVA_HOME=`dirname $(dirname $(readlink -f $(which javac)))
```

You will need to add this to your `~/.bashrc` file so it always takes effect whenever you open a new terminal.

Note that the ``JAVA_HOME`` variable may not be set at all on many systems.

## Tests

To run all the unit tests, use the following command:

```none
./gradlew check
```

RiskScape also has integration tests.
The newer integration tests extend `EngineCommandIntegrationTest` and can be run independently in your IDE.
Whereas the older integration rely on producing a RiskScape docker image first (via `./bin/docker-build.sh`)
in order to be run locally.

For more details on the commands required to run _all_ integration tests, refer to `.gitlab-ci.yml`.

## IDE setup

Whatever IDE you choose to use for development, you should check you can run the RiskScape JUnit tests
in it successfully, and can use the debugger.
For a typical unit test, try running `engine/core/src/test/java/nz/org/riskscape/engine/rl/MathsFunctionsTest.java`.

### Eclipse setup

Here are some tips if you use Eclipse as your IDE.

#### Installing Lombok

You will need to install [Lombok](https://projectlombok.org/).
Download and follow their [instructions](https://projectlombok.org/setup/eclipse) on how to install it.

#### Project Set up on Eclipse

1. Gradle can build the Eclipse project files for you using the following command:

    ```none
    ./gradlew eclipse
    ```

2. In Eclipse, click _File_ -> _Import_, then select _General_ -> _Existing projects into Workspace_ and click _Next_.

3. Under 'Select root directory' use your RiskScape git repository.
Under 'Options' make sure the 'Search for nested projects' option is selected.
Then under 'Projects' click 'Select All', and then click 'Finish'

4. You may need to build certain files to resolve the Eclipse errors. Try running:

    ```none
    ./gradlew installDist check
    ./bin/mk-eclipse-dirs.sh
    ```

If the errors do not disappear, you may need to select your projects in the Project Explorer pane, right-click, and select 'Refresh'.

If problems persist, you could also try selecting _Project_ menu -> _Clean_.

.. tip::
    Sometimes rebasing may introduce Eclipse errors as new projects or dependencies are added.
    You can rebuild your Eclipse project files using the command: ``./gradlew cleanEclipse eclipse``

## Javadoc

The RiskScape Javadoc comments support basic markdown, e.g.
- `**bold**` for **bold**
- `*italics*` for *italics*
- **Note:** You *must* always precede a numbered or unordered list with a blank line.
- `* starts a bullet point (or -)`
  * starts a bullet point (or -)
- `1. starts an ordered list (not hash)`
  1. starts an ordered list (not hash)
- `[hyperlinks](https://riskscape.org.nz)` [hyperlinks](https://riskscape.org.nz)

.. note::
    Markdown that you use in the documentation might not always work the same as
    markdown in Javadoc comments (they are rendered using two different implementations).

.

