.. _contributing-docs:

# Building the RiskScape documentation

## Prerequisites

.. warning::
    In order to build the documentation locally, you will need Docker installed.

.. _install_docker_linux:

### Installing Docker

.. note::
    The instructions here are for installing Docker on Linux Ubuntu.

1. To check if docker is installed, run: `docker --version`

2. Install docker if it is not there.
Refer to the [Docker documentation](https://docs.docker.com/engine/install/) for more details,
or try running the following command for Ubuntu users:

    ```none
    sudo apt-get install docker-ce docker-ce-cli containerd.io
    ```

3. Restart the terminal.

4. Run: `docker --version` or `docker ps` (for permission)

.. tip::
    You will want to be able to run Docker as a non-root user.
    Follow the instructions `here <https://docs.docker.com/engine/install/linux-postinstall/>`_ to set that up.

## Documentation

The RiskScape documentation is built using [Sphinx](https://en.wikipedia.org/wiki/Sphinx_(documentation_generator%29)
and is written in [Markdown](https://en.wikipedia.org/wiki/Markdown) and [reStructuredText](https://en.wikipedia.org/wiki/ReStructuredText).

There are scripts that will build the documentation using a Docker container,
which ensures they are built the same way each time.

The documentation is located in the RiskScape source tree under the `./docs` directory.
In that directory there is:

* `source` - this is where the source files for the documentation are. These are the
markdown files that can be edited.
* `build` - this folder will not exist until the docs have been built. The build creates
HTML files using the Markdown files as the source.

### Style guide

Documentation should be written to conform with the documentation style guide. Refer to `./docs/README.md` for more details.

### Building the documentation

To build the docs run this command:

```none
./bin/build-docs.sh
```

This will run the docker container with your source code and build the HTML files for
the documents. Once built open the index file at `docs/build/html/index.html`, e.g.

```none
firefox docs/build/html/index.html
```

Once you have proofread and confirmed your changes are complete, refer to the
:ref:`contributing_code` workflow.


