#! /bin/sh

BIN_DIR=$(dirname $0)
BUILD_DIR=docs/build/aspell

# remove previous test results
rm -rf ${BUILD_DIR}
mkdir --parents ${BUILD_DIR}

# Find all the markdown files
# Run ./spell-check.sh which will output any errors (it strips out markdown
# and command examples we're not interested in first, then runs aspell)
for doc in $(find docs/build/html -name '*.html') ; do
    out_dir=${BUILD_DIR}/${doc#"docs/build/html"}
    out_to=${out_dir}/$(basename ${doc}).aspell-list
    mkdir --parents ${out_dir}
    ${BIN_DIR}/spell-check.sh $doc > $out_to
done

# remove excellent files
find ${BUILD_DIR} -name '*.aspell-list' -empty -delete

# test for errors
if [ $(find ${BUILD_DIR} -name '*.aspell-list' | wc --lines) -ne 0 ]; then
    echo '*** Spelling errors found ***'
    find ${BUILD_DIR} -name '*.aspell-list' -print -exec cat {} \;
    exit 1
fi
