#  RiskScape documentation

**Note**: you will need docker installed in order to build a copy of
the RiskScape documentation locally.

## Types of documentation

### How-to guides
How-to guides help users solve a real-world task using RiskScape.

These guides should include full, step by step, worked examples using actual data.
Wherever possible using the Samoa tsunami example is preferred. (See the Getting started how-to
guide within `/docs/`).

The expected audience for a how-to guide is a hazard / risk researcher who is
new to RiskScape. 

### Reference guides
Reference guides are technical descriptions of how RiskScape works and how to use it.

Reference guides are intended for proficient users of the software. These users 
may be hazard analysts / risk researchers or developers looking to contribute to the project. 

### Developer guides
Developer are intended for software developers who want to contribute to the 
project by extending or modifying the RiskScape code base. 

### Built-in help 
Unlike the other documentation above, built-in help is available from within the
RiskScape application. It is intended to be useful for all users. 

Built-in help is sourced from the code and user supplied data. Descriptions should
be populated for all user supplied data (types, assets, hazards, functions). Where
necessary these descriptions can include public URLs to more information.

## Duplicating content
Where ever possible, duplication of help content is to be avoided. 

Priority is given to the in-built documentation. Where further context is required, the documentation in `/docs/`
should augment the in-built documentation rather than duplicate it.

## Building RiskScape documentation

The documentation is built using a docker container. Use the command below
which will do everything needed. This command will build a clean copy of both the 
Sphinx and the Javadoc documentation.

Note that on the first run it will build the `docbuilder` image so will take
a little longer.

```text
bin/build-docs.sh html
```

# Style guide

This style guide is a reference point that sets document writing standards for 
RiskScape. Use it to help clear up ambiguities and make sure anything you write 
is professional, meaningful and consistent.

Our goal is to be clear, concise and descriptive.

## Before you start
Are you and your reader on different levels of understanding? Always consider 
that the levels of technical understanding of your readers will vary, always aim
to simplify and breakdown concepts and technical language. 

Every time you start and finish a segment of writing review it and contemplate:
* Who you are and whether your tone is appropriate in this role
* Who you are writing for 
* What you are writing about
* And, how clearly your message or instruction can be understood.

## Audiences
We have two primary audiences that we write for:
1.  Hazard and Risk Researchers (Scientists) who understand the domain of hazard and risk modelling but have varying levels of comfort using a command line based tool. 
2.  Developers and Technical People who may be charged with maintaining a RiskScape instance, or contributing to the project.


## Spelling
Spelling used is New Zealand English.

Note that we use `-ize` over `-ise` (i.e. [Oxford Spelling](https://en.wikipedia.org/wiki/Oxford_spelling))

### Spell-check

The `docs/` files include spell-checking as part of the build.  All markdown files are checked using
`aspell` for mistakes.  A custom dictionary is kept in `docs/aspell/riskscape.txt` - think really hard
before adding words to this.

All code and code blocks are excluded from the spell checker.

You can run the spell checker using the `bin/spell-check-docs.sh`.  If `aspell` is not
installed on your workstation, you can run it via the `build-docs.sh` command

## Headings
Use sentence case, i.e. capitalize the first word and proper nouns.
E.g. 'Example of RiskScape sentence case'.
We don't use title case, i.e. 'This is a Style to Avoid Using'.

## Command and INI examples

INI file examples and blocks of output should always be enclosed in a block surrounded by <tt>```</tt>.
Example commands can either use the same approach, or use single backticks where appropriate.

Always specify the [language](https://pygments.org/docs/lexers/) that the block is in. E.g.
```text
    ```ini
    foo = bar
    ```
```

We should always try to make example commands as clear as possible to new users,
especially users that are unfamiliar with CLI tools. To that end:
* Always use the long version version of the CLI options, at least for the first example.
I.e. use `--help` over `-h`.
* To simplify commands that the user will likely run often,
you can then give a follow-up example that uses the short CLI options. E.g.
    ```text
    To display the model output in CSV format, use: `riskscape model run kaiju:stomp --outfile - --format csv`

    You can also shorten this command to: `riskscape model run kaiju:stomp -o - -f csv`
    ```
* Use a space between the option's value rather than `=`.

Note that command/file examples in a Sphinx tip/note/etc box need to use double-backticks,
otherwise they just get rendered as italics/emphasis.

## Voice
We are deliberately use a friendly, informal voice that reflects the language
and tone the team uses in person.

## Make it easy for your readers
To make reading easy: 
* make the purpose of your writing clear at the start 
* answer your readers' likely questions 
* choose plain words, be concise, and explain technical terms 
* use a read-friendly tone (use 'you' and 'we' if appropriate).

Some specific guidance:
* RiskScape is always capitalized.
* We prefer not to use contractions in text. Full words are easier to read.
* We do not use NZ slang or in-jokes. We are friendly, informal not casual.
* Hyphenate words where appropriate. It can make long sentences easier to parse. E.g. 'how-to guide', 'built-in language'.

## Structure and readability
RiskScape works with complex concepts. We aim to explain these were needed as
clear and concisely as possible.

We attempt to structure the documentation so it is scannable. This means:
* short paragraphs
* bullet points
* using headings and sub headings

## Plain, active, and concise
Writing clearly means keeping your reader in mind. That usually means to write in plain English, use concise and active words.
Examples:

### Plain 
Replace complex words with plain words. Plain Jane is your best friend when
writing instructional content. 

Here are some examples of complex words and their simple replacements:

* ‘attempt’ or ‘endeavour’ with ‘try’
* ‘discontinue’ or ‘terminate’ with ‘stop’ 
* ‘implement’ or ‘undertake’ with ‘do’ or ‘carry out’
* ‘moreover’ with ‘and’, ‘also’ or  ‘as well’
* ‘similarly’ with ‘also‘.

### Concise
Being too wordy will fatigue your reader's brain, when you can – be concise.

Here are some examples of single words that can replace common wordy phrases:

* ‘by means of’ replace with ‘by’
* ‘despite the fact that’ replace with ‘although’
* ‘for the purpose of’, replace with, ‘to’ 
* ‘on behalf of’, replace with, ‘for’
* ‘on the grounds that’, replace with, ‘because’. 


### Active 
Replacing abstract nouns (naming words for non-physical things) with verbs 
(doing words) is a simple way to make your writing more active and concise. 

Below are examples of active replacements:

* ‘do an investigation’ with ‘investigate’ 
* ‘form an agreement’ with ‘agree’ 
* ‘have a discussion’ with ‘discuss’ 

## Common mistakes

### Dates

Our preferred date style is: Monday, 27 January 2020. 

In a sentence write: 'On Monday, 27 January 2020, we released a new version of our program to production.' 

Incorrect: 
* Monday, 27th of January 2020 
* January 27, 2020 
* January 27th 2020

### Times
Correct: 'am' and 'pm'. E.g. I got a pager call at 4am. 

Incorrect: 'a.m.' and 'p.m.' 

When giving exact times, use a full stop instead of a colon.

Correct: 10.30 or 10.30am 

Incorrect: 10:30 or 10:30pm 

### Numbers

0–9 – Use words for the numbers zero to nine, thereafter use 10, 11, 12 etc. 

24/7 – If appropriate. Otherwise "24 hours a day, 7 days a week." 

Thousand separator – Separate hundreds from thousands using a comma. For example: 

* NZ$1,546
* 6,500,000

### Units of measurement 

There is no space between the number and the unit or symbol. For example: 

* NZ$12,500
* 250GB

# Sphinx cheat sheet

## In page links

To make a link to another section in the same page you need to put a ref id
on the target heading.

```
.. _mytarget
## Target Heading
```

Then you can use a standard markdown link like `[link label](#mytarget)`

Note that spaces and underscores in the target ref id seems to stop this from working.

## Link to another page

Use

- `[link label](page.html)`
- `[link label](page.html#mytarget)`

Note, m2r docs suggest that`(page.md)` should work. Trying that proves otherwise though.
