SET CLIENT_ENCODING TO UTF8;
SET STANDARD_CONFORMING_STRINGS TO ON;
BEGIN;
CREATE TABLE "nz-rail-station-points" (gid serial,
"t50_fid" int4,
"name_ascii" varchar(75),
"macronated" varchar(1),
"name" varchar(75));
ALTER TABLE "nz-rail-station-points" ADD PRIMARY KEY (gid);
SELECT AddGeometryColumn('','nz-rail-station-points','geom','2193','POINT',2);
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6082054','Greenlane Station','N','Greenlane Station','010100002091080000F82053BDA7DB3A41C660761535915641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6082051','Penrose Station','N','Penrose Station','01010000209108000004D58997D9E13A41F2270B9EF58E5641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6082053','Ellerslie Station','N','Ellerslie Station','010100002091080000E86CD1DB56DF3A41DEE428E334905641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6082055','Remuera Station','N','Remuera Station','010100002091080000B8185D4B9AD73A41D6FD6EE31B925641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6082056','Meadowbank Station','N','Meadowbank Station','01010000209108000068733DDBF5E33A41C5D05599B2935641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6082057','Glen Innes','N','Glen Innes','010100002091080000F89ACAB57BEF3A413C56198D49925641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462510','Hindon Station','N','Hindon Station','0101000020910800005038F43653413541418523F4DCD25241');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462511','Pukerangi Station','N','Pukerangi Station','010100002091080000CC759F9423193541B316BB2BE7DA5241');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462512','Middlemarch Station','N','Middlemarch Station','01010000209108000034ACD3E725FC34412873332C6DE85241');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462516','Pleasant Point Station','N','Pleasant Point Station','010100002091080000E05D674F43233641A4FFE5EEF6715341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462531','Tinwald','N','Tinwald','01010000209108000078F1295AE1D436411FC3C02A78975341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462534','Darfield Station','N','Darfield Station','01010000209108000050F4DB37D451374199A18D39F7C65341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462543','Glenmark Station','N','Glenmark Station','0101000020910800002C5E5B4BF41C384107A919677EF65341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462541','Waikari Station','N','Waikari Station','010100002091080000D4790B11890C3841A32FCA1768FF5341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462540','Kaikoura Station','N','Kaikoura Station','01010000209108000010D59721D544394164F21363AC3D5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462556','Kaiwharawhara Station','N','Kaiwharawhara Station','01010000209108000000AF08B62CB43A41C9940F398BB75441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462562','Ngauranga Station','N','Ngauranga Station','010100002091080000DCDCDB7182BB3A41B4322F66B1B85441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462585','Mana Station','N','Mana Station','010100002091080000342C7F7AE2CE3A413B72A4B23FC95441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462575','Western Hutt Station','N','Western Hutt Station','0101000020910800002CCE51D3E3D43A4157EE05A598BC5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462576','Melling Station','N','Melling Station','010100002091080000A481589E14DA3A4127361F6F78BD5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462579','Wingate Station','N','Wingate Station','0101000020910800005843E24E58EA3A417A93DF7CFBBE5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462580','Taita Station','N','Taita Station','0101000020910800002426E16269EC3A414ED87E5AE1BF5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462581','Pomare Station','N','Pomare Station','01010000209108000040139A3478EF3A41F4D896000EC15441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462625','Ohakune Station','N','Ohakune Station','010100002091080000385A9F78AE963B4119AF2DFAA57F5541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462635','Gisborne Station','N','Gisborne Station','010100002091080000C47D18789F143F41D708E08B15C65541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462649','Manukau Station','N','Manukau Station','01010000209108000018A9C6C00CF63A4158681181B7855641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462672','Orakei Station','N','Orakei Station','01010000209108000088D4ED3436E03A415C0A48FD1E945641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462673','Panmure Station','N','Panmure Station','010100002091080000B460CC4FC2ED3A415FC0301C3D905641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462679','Waihi Station','N','Waihi Station','010100002091080000101D6E90E23D3C414D08DBCDE9575641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462681',NULL,'N',NULL,'010100002091080000101772CFA0E33941C14FF7F6AE355741');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6099114',NULL,'N',NULL,'010100002091080000442C51A94B1D384134E0F8C013F65341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462621','Ormondville Station','N','Ormondville Station','010100002091080000B0B4EFA899A83C41208617C2A3305541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462678','Waikino Station','N','Waikino Station','01010000209108000098EEA24BC12A3C41272D6E2F52565641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462537','Hokitika Station','N','Hokitika Station','0101000020910800009C01088E42DF35415995560A15195441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462571','Linden Station','N','Linden Station','010100002091080000CC74062C6BC23A41C26A98516EC25441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6455509','Sheffield','N','Sheffield','0101000020910800005CAD67B7B13337416AB230B3CED15341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6082050','Te Papapa','N','Te Papapa','010100002091080000A82BC979CADC3A41C5698F51E68D5641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6082052','Sylvia Park Station','N','Sylvia Park Station','01010000209108000064E8C72D28EB3A41C7BA9F0A6D8E5641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462563','Petone Station','N','Petone Station','0101000020910800002C1C41721CCE3A41D15CA75088BB5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462565','Woburn Station','N','Woburn Station','010100002091080000689DF1F1D4DB3A41613AAD7596BB5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462566','Waterloo Station','N','Waterloo Station','010100002091080000C804354823DF3A41EF76BD9D53BC5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462595','Matarawa Station','N','Matarawa Station','01010000209108000088AF59BFBF8D3B414AF2B6441ECD5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462596','Carterton Station','N','Carterton Station','010100002091080000288106ABC7A63B412200388BE8CF5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462612','Solway Station','N','Solway Station','01010000209108000048F5BC1BEDC83B415C094F9004D75441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462613','Renall Street Station','N','Renall Street Station','010100002091080000BC2B6A4F94CD3B41BBBE2A60A7D75441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462614','Masterton Station','N','Masterton Station','01010000209108000010F87E75D9D23B413FE629165FD85441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462616','Pahiatua Station','N','Pahiatua Station','01010000209108000058539730C20E3C41808537F5B40D5541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('5940243','Woodville Station','N','Woodville Station','0101000020910800007C233ADF98213C41647CE2B45D185541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462683','Taumarere Station','N','Taumarere Station','0101000020910800002C3D6B263DEE3941D578A1C0BE375741');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6099113','Rangiora','N','Rangiora','010100002091080000B8A53E3184EA3741D687B666B8DB5341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462499','Mataura Station','N','Mataura Station','010100002091080000EC180EB1168B3341C70494E189995241');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462501','Balclutha Station','N','Balclutha Station','01010000209108000044CF66A5FD92344145FAED2F97975241');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462503','Gore Station','N','Gore Station','010100002091080000B811681B63A133411AEB3E7DFEA35241');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462506','Mosgiel Station','N','Mosgiel Station','0101000020910800009CB89FFDF04635414550DE05EBBF5241');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462507','Wingatui Station','N','Wingatui Station','0101000020910800000CD2B8FF24523541F9B0DEB303C15241');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462508','Dunedin Station','N','Dunedin Station','01010000209108000040A9D33FB57635418492C2A37CC15241');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462513','Palmerston Station','N','Palmerston Station','010100002091080000E42D9000EAB03541B47BF2146CEC5241');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('5940239','Christchurch Station','N','Christchurch Station','010100002091080000F4BB02B242EE3741BCAFCE98BFC15341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462529','Cass Station','N','Cass Station','0101000020910800000C0B304D70DE36417A8309ECC7F75341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462539','Mina Station','N','Mina Station','010100002091080000308CA36261B338414547D9EEDE105441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462643','Wellsford Station','N','Wellsford Station','0101000020910800005CE8F57A50813A4153A6BE9B29D25641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6115096','Invercargill','N','Invercargill','0101000020910800006CA5102F95F43241B833C32EFE7F5241');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462615','Shannon Station','N','Shannon Station','010100002091080000DCA7DEAC7B873B41F4DDE53BAC035541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462627','Taumarunui Station','N','Taumarunui Station','010100002091080000C4F77BFD62693B41F9E184285BB85541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462632','Putaruru Station','N','Putaruru Station','01010000209108000064E299391C233C41E5A563A219115641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6159455','Featherston Station','N','Featherston Station','010100002091080000505AFBD318663B418187B9C864C65441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462509','Sawyers Bay Station','N','Sawyers Bay Station','0101000020910800006888EEEF2E9335416AC52E169BC75241');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462594','Woodside Station','N','Woodside Station','0101000020910800002890F6A23C7E3B4172BE3C1D37CB5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6225479','Fairlight Station','N','Fairlight Station','0101000020910800002C6392AD174033419832C5D5F7EC5241');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6225480','Kingston Station','N','Kingston Station','010100002091080000880A0BD86B49334164F552E9E8F65241');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462598','Te Kuiti Station','N','Te Kuiti Station','010100002091080000502E72FD7D4D3B41BA8096DBD4F35541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6236673','Timaru Station','N','Timaru Station','010100002091080000808A2004894B364104044A4C7E635341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6236674','Springfield','N','Springfield','01010000209108000038763D9463173741965823019DD75341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6236675','Hawera','N','Hawera','0101000020910800005C85903C2E193A41C4383FBAFC6D5541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462515','Keanes Crossing Station','N','Keanes Crossing Station','01010000209108000030E4E1369A29364174920A7C48715341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462574','Paremata Station','N','Paremata Station','010100002091080000944A4BAE23CE3A41ECC4FDBB14C85441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462583','McKirdy Station','N','McKirdy Station','010100002091080000E4B8DA10DBF73A41C7BCC99401C35441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462584','Silverstream Station','N','Silverstream Station','010100002091080000F0B199DEFBFC3A4112D541745FC35441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462586','Plimmerton Station','N','Plimmerton Station','010100002091080000B4B99519A3CE3A4179357E2483CA5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462587','Pukerua Bay Station','N','Pukerua Bay Station','010100002091080000B09F59AE81D53A41B667399873CF5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462588','Heretaunga Station','N','Heretaunga Station','010100002091080000C0FA8D4927023B41661117D9E1C35441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462589','Trentham Station','N','Trentham Station','0101000020910800007029853D3C063B416B5631D356C45441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462591','Upper Hutt Station','N','Upper Hutt Station','010100002091080000907C261DF5103B4122DADA6D8DC55441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462592','Maymorn Station','N','Maymorn Station','010100002091080000C0DF26DBF6253B413D3C3AB462C75441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462607','Paekakariki Station','N','Paekakariki Station','010100002091080000E8DDC18A2EEC3A411E293747D6D45441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462608','Paraparaumu Station','N','Paraparaumu Station','01010000209108000094054C0146FE3A418BD7375B62DC5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462609','Waikanae Station','N','Waikanae Station','01010000209108000070AFC0E119123B4167039B259FE05441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462528','Ikamatua Station','N','Ikamatua Station','01010000209108000054D94BE33CC23641C05E84ECA04A5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462530','Reefton Station','N','Reefton Station','010100002091080000C872229691F73641FE596A4BE95C5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6398521','Greymouth Station','N','Greymouth Station','010100002091080000701D2686802C3641F2050F39B5365441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6313858','Moorhouse','N','Moorhouse','01010000209108000058BA9A37B50B38413A6E8929B0BE5341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6313859','Ferrymead','N','Ferrymead','010100002091080000B07B2420690D38411DAE6A4D36BF5341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462514','Oamaru Station','N','Oamaru Station','0101000020910800008C9A4D10A8FB354191682B8714175341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462524','Inchbonnie Station','N','Inchbonnie Station','010100002091080000882F4CE61B823641F7065F80F5185441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462525','Jacksons Station','N','Jacksons Station','010100002091080000484CC0B29F923641849EA7A040175441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462526','Moana Station','N','Moana Station','010100002091080000D85F63DE22823641D4F34A382D295441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462550','Seddon Station','N','Seddon Station','010100002091080000F4467C3365C7394137EA9114B98B5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462551','Blenheim Station','N','Blenheim Station','010100002091080000E45B30E6E9A2394154F48E78A69D5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462552','Picton Station','N','Picton Station','0101000020910800008CD825F2A2B23941F5336C2A82B55441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462553','Crofton Downs Station','N','Crofton Downs Station','010100002091080000408F24E226AC3A410DCF6FB224B85441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462554','Ngaio Station','N','Ngaio Station','01010000209108000040A7F88AD9AD3A41C21C263A8CB85441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462555','Awarua Street Station','N','Awarua Street Station','010100002091080000D0ED4FBACAAE3A41EF61B5E60BB95441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462557','Simla Crescent Station','N','Simla Crescent Station','01010000209108000010BB130F06B23A41A9545CECFCB85441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462558','Box Hill Station','N','Box Hill Station','01010000209108000054499D9069B33A41448B6CC70EB95441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462560','Raroa Station','N','Raroa Station','0101000020910800004403212CDBB73A41C26934558BBA5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462561','Johnsonville Station','N','Johnsonville Station','010100002091080000041DB6D4E7B83A4159D391BB7FBB5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462590','Wallaceville Station','N','Wallaceville Station','010100002091080000F0FCDB3B0E0D3B417133D8DA19C55441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462617','Palmerston North Station','N','Palmerston North Station','01010000209108000044538606BEC63B416E0884F62F195541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462623','Taihape Station','N','Taihape Station','010100002091080000684BF15221133C41A52E3C88C8605541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462605','National Park Station','N','National Park Station','010100002091080000A01A81F47D913B41549CCF854E985541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462680',NULL,'N',NULL,'010100002091080000E8D1F3433CCD3941477F0A88A7335741');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6427255','Rolleston','N','Rolleston','01010000209108000064D61E2AA3A737418CDFF6585DBC5341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462532','Ashburton','N','Ashburton','01010000209108000064B6ACE9F0E236413A013D80009A5341');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462521','Arthur''s Pass Station','N','Arthur''s Pass Station','010100002091080000D077048D85A03641B6297E257D015441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462522','Otira Station','N','Otira Station','010100002091080000B8F765751F9F364173A1B462FF0D5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462538','Westport Station','N','Westport Station','01010000209108000040724ADDA6A236413B7B048755825441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462559','Khandallah Station','N','Khandallah Station','0101000020910800007C9BB391F9B43A41CB3AACCF65B95441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462564','Ava Station','N','Ava Station','010100002091080000A06A392D81D53A41D887BA41C2BB5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462567','Takapu Road Station','N','Takapu Road Station','010100002091080000C8B3BDF3F4C03A4133FC1D8B95BF5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462568','Redwood Station (south platform)','N','Redwood Station (south platform)','010100002091080000C00BDAAC97C03A414C2C7C6288C05441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462569','Redwood Station (north platform)','N','Redwood Station (north platform)','01010000209108000038C12B30B7C03A4176F00C04C4C05441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462570','Tawa Station','N','Tawa Station','0101000020910800004883300124C13A4128F2559851C15441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462573','Porirua Station','N','Porirua Station','010100002091080000F06E7C8F58C63A41DF8FC836BAC45441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462577','Epuni Station','N','Epuni Station','01010000209108000078969B8929E23A4160441C99FEBC5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462578','Naenae Station','N','Naenae Station','01010000209108000044C582A566E73A41C800847601BE5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462582','Manor Park Station','N','Manor Park Station','0101000020910800005816C40B93F23A41A2C7478273C25441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462606','Waverley Station','N','Waverley Station','01010000209108000074BEED60428A3A415E7CACC07C595541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462603','Stratford Station','N','Stratford Station','0101000020910800004883628DA71B3A41C1128FA6B5875541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462610','Otaki Station','N','Otaki Station','0101000020910800001C23F6A60B313B41DCCAFF6AC2EC5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462611','Levin Station','N','Levin Station','010100002091080000087D40708C5A3B412F8A59B1CBFA5441');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462620','Dannevirke Station','N','Dannevirke Station','010100002091080000D4C2B452646F3C41D654F4728C265541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6248170','Waipukurau','N','Waipukurau','010100002091080000F03060DDD50A3D4185A3730A6C3C5541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462599','Hastings Station','N','Hastings Station','01010000209108000024E792EA71733D4108A6722EDB615541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462600','Napier Station','N','Napier Station','01010000209108000034900F783E8D3D4138AF14A000715541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462604','Inglewood Station','N','Inglewood Station','0101000020910800009C0603BBB5013A4141D7BDD6449C5541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462601','Murupara Station','N','Murupara Station','010100002091080000F05D9AF110563D41B787F49B42E35541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('5940244','Otorohanga Station','N','Otorohanga Station','010100002091080000602F1B8BDA5E3B41A69E8512E4035641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462630','Hamilton Station','N','Hamilton Station','010100002091080000E807C21835753B410516EC529C2E5641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462631','Morrinsville Station','N','Morrinsville Station','010100002091080000488AF12DF7CF3B4161544689213C5641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462634','Matamata Station','N','Matamata Station','01010000209108000068A38A57F1223C41750CE3B3372B5641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462597','Tauranga Station','N','Tauranga Station','010100002091080000B843B2251BAE3C41F264C81C37385641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462636','Sunnyvale Station','N','Sunnyvale Station','010100002091080000F8FC8558F9A13A41F1485322B1905641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462637','Swanson Station','N','Swanson Station','010100002091080000D4C9910E158F3A412A864A0413945641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6248171','Henderson Station','N','Henderson Station','01010000209108000040CEDBA7C0A13A41153C428E68925641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462640','Sturges Road Station','N','Sturges Road Station','010100002091080000D066DB3D2A9E3A41E41241CD3E935641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462639','Ranui Station','N','Ranui Station','0101000020910800007CD7732152983A41D3C8CE4BDA935641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462641','Waitakere Station','N','Waitakere Station','010100002091080000D4670FFE9C833A41401306B3F3955641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462642','Helensville Station','N','Helensville Station','01010000209108000084FF6B9854643A41B546B59259A95641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462644','Glenbrook Station','N','Glenbrook Station','0101000020910800005C017ED212D53A418CC48B70B66E5641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462645','Pukekohe Station','N','Pukekohe Station','0101000020910800007CFC5670F0FF3A419F2F6C151F6F5641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462647','Te Mahia Station','N','Te Mahia Station','0101000020910800002CFFFCE04B003B414C1B1CD3AF815641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462646','Manurewa Station','N','Manurewa Station','01010000209108000018EC63EBE2FC3A41C511A6F98F825641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462648','Homai Station','N','Homai Station','010100002091080000A8C6CB1B85F53A411A594347A9835641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462650','Puhinui Station','N','Puhinui Station','010100002091080000E0A3CF903BEF3A41587A0CF944865641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462651','Papatoetoe Station','N','Papatoetoe Station','010100002091080000D8B600E9FAEC3A412D36042F9C875641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462652','Glen Eden Station','N','Glen Eden Station','0101000020910800002CEFDE3C48A93A4123FD100C338F5641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462653','Fruitvale Road Station','N','Fruitvale Road Station','010100002091080000286DB5AA00AF3A41E70CB3E30D8F5641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462654','New Lynn Station','N','New Lynn Station','010100002091080000D46798DF09B43A41D2CB18823F8F5641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6248172','Avondale Station','N','Avondale Station','010100002091080000441775F360B93A41D0E575E48F905641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462656','Mount Albert Station','N','Mount Albert Station','010100002091080000E45C8EAB9ABE3A41AAD8852FDA915641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462657','Baldwin Station','N','Baldwin Station','010100002091080000543C8A92E1C03A4109997B849E925641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462658','Morningside Station','N','Morningside Station','010100002091080000848A7F3A1EC63A41842A369BE5925641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462659','Kingsland Station','N','Kingsland Station','010100002091080000A05630BEA3C93A41EC3C68D32C935641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6082045','Mount Eden Station','N','Mount Eden Station','01010000209108000038582C3770CE3A4199AC40F59E935641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462661','Otahuhu Station','N','Otahuhu Station','01010000209108000030DD34CFB3E73A4112AD4380DD8A5641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6082049','Westfield Station','N','Westfield Station','0101000020910800004CF4BE2E21E73A417AD814400F8C5641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462664','Middlemore Station','N','Middlemore Station','010100002091080000D48DC0A568E93A41956B69C13E895641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6082046','Boston Road Station','N','Boston Road Station','010100002091080000442E11B756D23A41454F0575DD935641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6082047','Newmarket Station','N','Newmarket Station','01010000209108000024AA07DC5BD53A414D3E4F6169935641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462676','Papakura Station','N','Papakura Station','0101000020910800005C4912CC240E3B41834D8EA6EE7D5641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462677','Takanini Station','N','Takanini Station','010100002091080000103255B3BB043B4107B7537C9B805641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6479078','Waiouru Station','N','Waiouru Station','010100002091080000803B3A9205EA3B418375AD7A9A765541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6536084','Whangarei','N','Whangarei','01010000209108000088F1120EC23D3A413DF85F574F0F5741');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('2462618','Feilding Station','N','Feilding Station','010100002091080000C06CC976D0BF3B41E26BF0EB06265541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6633269','Onehunga','N','Onehunga','01010000209108000004EDB6867FD73A411F533F064C8D5641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6633270','Parnell','N','Parnell','01010000209108000054191B60FCD43A41070E171302955641');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6682654','Marton','N','Marton','010100002091080000280EC44C70863B4110063E9675355541');
INSERT INTO "nz-rail-station-points" ("t50_fid","name_ascii","macronated","name",geom) VALUES ('6748777','Kenepuru','N','Kenepuru','0101000020910800005C38391885C43A41413CBFA16EC35441');
COMMIT;
ANALYZE "nz-rail-station-points";
