#!/bin/bash
#
# Some pre-release sanity checks.
#

if ! [[ "$(< VERSION)" =~ ^[0-9]+\.[0-9]+\.[0-9]+$ ]]
then
  echo "Invalid value in VERSION file (should be X.Y.Z)"
  exit 1
fi

if ! grep -F "$(< VERSION)" -q CHANGELOG.md
then
  echo "CHANGELOG.md does not mention version $(cat VERSION)"
  exit 1
fi

if [ -v CI ] && [ -z "${CI_COMMIT_TAG:-}" ]
then
  echo "This is not a tagged build"
  exit 1
fi

if [ -v CI ] && [ "$CI_COMMIT_TAG" != "$(< VERSION)" ]
then
  echo "Release tag does not match version in VERSION file"
  exit 1
fi
