#! /bin/sh

. $(dirname $0)/constants.sh
#Attempt to create .gradle, else if it doesn't exist docker volumn mount will
#create it owned by root:root
mkdir -p $HOME/.gradle

IMAGE=${GRADLE_IMAGE:-gradle-${IMAGE_UID}}

# Build RiskScape with JDK17.
JAVA_HOME=/usr/lib/jvm/java-17-openjdk-amd64

# NB - we might decide we want to forward all environment variables with a certain pattern or prefix, in
# which case we might want something like...
# --env-file=<(env | grep -E '^RISKSCAPE_')
# this should forward all environment variables that begin with riskscape

docker run --rm \
       --net host \
       --env JAVA_HOME=${JAVA_HOME} \
       --env RS_GITLAB_DEPLOY_TOKEN=${RS_GITLAB_DEPLOY_TOKEN} \
       -v $(readlink -f $0)/../..:/home/gradle/project  \
       -v $HOME/.gradle:/home/gradle/.gradle \
       $IMAGE -- --no-daemon $@
