#! /bin/bash
#
# Builds the following images:
# - riskscape-cli
# - riskscape-cli-ogr
# - riskscape-cli-hdf5
#
set -ex

RISKSCAPE_BASE=$(dirname $0)/..

cd "${RISKSCAPE_BASE}"

IMAGE_VERSION=${CI_PIPELINE_ID:-latest}

. bin/constants.sh

if [ "${SKIP_DEPENDENT_IMAGES}" != 'yes' ]; then
   ./bin/build-gradle-image.sh
   ./bin/docker-gradle.sh installDist
fi

# Use that container to compile riskscape
# allow reuse of vpn by using --net host, not very secure, but ok for a build?
# Now build a container containing only the riskscape cli
docker build --build-arg BASE_IMAGE . -f Dockerfile.cli -t riskscape-cli:${IMAGE_VERSION}

# Build riskscape-cli-ogr (note ogr has a different base image)
docker build . -f ./plugin/ogr/Dockerfile -t riskscape-cli-ogr:${IMAGE_VERSION}

# Build riskscape-cli-hdf5
docker build --build-arg BASE_IMAGE=riskscape-cli:${IMAGE_VERSION} ./plugin/hdf5 -t riskscape-cli-hdf5:${IMAGE_VERSION}
