#!/bin/bash
# Builds the riskscape user documents by combining the results of the sphinx and
# the gradle build
set -e

BUILD_JAVADOCS=$(printf '%s\n' "$@" | grep -P '^--build-javadocs$' || :)

#Needs to be run from root of the project directory.
cd $(dirname $0)/..

#Build the doc builder image first
bin/build-docbuilder-image.sh

#Build markdown files from the built-in reference info.
#This also ensures that the license file exists with correct year in
#engine/app/build for the docs to pick up
./gradlew installDist
engine/app/build/install/riskscape/bin/riskscape docs

# Get the builder image name
DOCBUILDER_IMAGE=${DOCBUILDER_IMAGE:=docbuilder-$(id -u)}

# get the current docs VERSION, stripping any newlines or git SHA
VERSION=$(cat VERSION | sed 's/-.*//' | tr -d '\n')

# NB this mounts the source root so that all the source can be potentially
# used/referenced/included in the docs, in particular the license and
# copyright info
docker run --rm -v $(pwd):/home/docbuilder -w /home/docbuilder/docs \
       --entrypoint make -e VERSION=$VERSION ${DOCBUILDER_IMAGE} clean html

# Spell checking the built HTML
# PS set NO_SPELL_CHECK to skip spell checking
if [ -z "$NO_SPELL_CHECK" ]; then
  # NB root source tree is mounted for this one, not docs
  mkdir --parents docs/build
  docker run --rm -v $(pwd):/home/docbuilder --entrypoint bash ${DOCBUILDER_IMAGE} docs/bin/spell-check-docs.sh
fi

if [[ -n "${BUILD_JAVADOCS}" ]] ; then
  ./bin/docker-gradle.sh javadoc

  mkdir --parents  docs/build/html/javadoc
  cp -r engine/core/build/docs/javadoc docs/build/html/javadoc/engine-core
  cp -r engine/api/build/docs/javadoc docs/build/html/javadoc/engine-api
  cp -r engine/app/build/docs/javadoc docs/build/html/javadoc/engine-app

  cp -r plugin/defaults/build/docs/javadoc docs/build/html/javadoc/plugin-defaults
  cp -r plugin/cpython/build/docs/javadoc    docs/build/html/javadoc/plugin-cpython
  cp -r plugin/hdf5/build/docs/javadoc       docs/build/html/javadoc/plugin-hdf5
  cp -r plugin/jython/build/docs/javadoc     docs/build/html/javadoc/plugin-jython
  cp -r plugin/netcdf/build/docs/javadoc     docs/build/html/javadoc/plugin-netcdf
  cp -r plugin/ogr/build/docs/javadoc        docs/build/html/javadoc/plugin-ogr
  cp -r plugin/openquake/build/docs/javadoc  docs/build/html/javadoc/plugin-openquake
  cp -r plugin/postgis/build/docs/javadoc    docs/build/html/javadoc/plugin-postgis
  cp -r plugin/usgs/build/docs/javadoc       docs/build/html/javadoc/plugin-usgs
  cp -r plugin/wizard/build/docs/javadoc     docs/build/html/javadoc/plugin-wizard
  cp -r plugin/wizard-cli/build/docs/javadoc docs/build/html/javadoc/plugin-wizard-cli
fi

cd examples
zip -r ../docs/build/html/getting-started.zip getting-started/
zip -r ../docs/build/html/models-intro.zip models-intro/
zip -r ../docs/build/html/wizard-models.zip wizard-models/
zip -r ../docs/build/html/project-tutorial.zip project-tutorial/
zip -r ../docs/build/html/intermediate-modelling.zip intermediate-modelling/
zip -r ../docs/build/html/geoprocessing-tutorial.zip geoprocessing-tutorial/
zip -r ../docs/build/html/expressions-tutorial.zip expressions-tutorial/
zip -r ../docs/build/html/pipeline-basics.zip pipeline-basics/
zip -r ../docs/build/html/pipeline-advanced.zip pipeline-advanced/
zip -r ../docs/build/html/pipeline-parameters.zip pipeline-parameters/
zip -r ../docs/build/html/table-model.zip table-model/
zip -r ../docs/build/html/netcdf.zip netcdf/
zip -r ../docs/build/html/jupyter.zip jupyter/
zip -r ../docs/build/html/python-output.zip python-output/
zip -r ../docs/build/html/subpipelines.zip subpipelines/
cd -
cd docs/build/html
if [ -n "${CI_COMMIT_SHORT_SHA}" ] ; then
  # if we have a CI commit sha we put it in the zip. the platform microsite
  # publish script likes to see it.
  echo ${CI_COMMIT_SHORT_SHA} > _commit-sha
fi
# we used to build the docs zip so it contained a riskscape-docs directory with the docs.
# but now we publish the docs as a microsite we need the index.html in the root directory
# of the zip.
zip -r ../riskscape-docs.zip ./
cd -
