#! /bin/bash
#Builds a base image that all other riskscape images uses

. $(dirname $0)/constants.sh

set -e


IMAGE=${BASE_IMAGE:=gitlab.catalyst.net.nz:4567/riskscape/riskscape/base}

build_args=()
build_args=("${build_args[@]}" --label org.opencontainers.image.authors="Riskscape Team <riskscape@catalyst.net.nz>")
build_args=("${build_args[@]}" --label maintainers="Riskscape Team <riskscape@catalyst.net.nz>")
build_args=("${build_args[@]}" --label nz.org.riskscape.name="riskscape")

if test -v CI
then
  build_args=("${build_args[@]}" --label nz.org.riskscape.build="${CI_JOB_ID}")
  build_args=("${build_args[@]}" --label nz.org.riskscape.commit="${CI_COMMIT_SHA}")
  build_args=("${build_args[@]}" --label nz.org.riskscape.version="${CI_COMMIT_TAG}")
  build_args=("${build_args[@]}" --label org.opencontainers.image.revision="${CI_COMMIT_TAG}")
fi

build_args=("${build_args[@]}" --label org.opencontainers.image.licenses="GPL3 for RESEARCH PURPOSES ONLY")
build_args=("${build_args[@]}" --label org.opencontainers.image.source="https://riskscape.org.nz/docs/intro/downloads.html")
build_args=("${build_args[@]}" --label org.opencontainers.image.url="https://riskscape.org.nz")

docker pull $IMAGE || true

docker build \
       --cache-from $IMAGE \
       "${build_args[@]}" \
       . -f Dockerfile.base \
       --tag ${IMAGE}
