Riskscape Engine
================

This directory contains the Riskscape source code and build tools.

Riskscape is:

- Java, JDK8 (but we encourage running on JDK17 so we can upgrade when it suits)
- Built using gradle
- Has dockerized build scripts
- Has integration tests that are run on docker images

The Riskscape development team use Ubuntu Linux. All of the commands and
scripts refered to should work well on Ubuntu or any other modern debian
based operating system.

# Project layout

Riskscape is made up of multiple sub-projects.

- engine, the core engine
- core, core API's required by sub-projects
- cli, the command line interface
- defaults, default plugin. provides default functionality,
- plugins/jython, implements functions and types in jython(python2)
- plugins/<others>, provide additional functionality in a plugable way

- test-shared, library useful for tests
- test-integration, where integration tests are

# Usage

Can test this out on your local machine or inside a container

## Traditional build

Assumes you have java(JDK8) installed

```
./gradlew installDist
./engine/app/build/install/riskscape/bin/riskscape --help
```

The *installDist* build target will build the riskscape software so that the CLI
can be run from *./engine/app/build/install/riskscape/bin/riskscape*.

Other useful build targets are:
- clean, removes all built artifacts
- check, checks code style and runs unit tests
- distzip, assembles built software into a zip bundle to distribute
- publishToMavenLocal, builds and installs project's jars to your ~/.m2 directory

## Using Docker

Assumes you have a recent version of docker installed

```
# tests and builds riskscape using a dockerized build image
./bin/docker-test.sh

# install the results on docker images *riskscape-cli*, *riskscape-cli-ogr*, *riskscape-cli-hdf5*
./bin/docker-build.sh

# to run Riskscape on *riskscape-cli* image
docker run riskscape-cli -c "riskscape --help"

# to run *riskscape-cli* with your uid, and use a volume mounted riskscape home directory
docker run --user $(id -u) -v <path to a riskscape home directory>:/home/riskscape -w /home/riskscape \
  riskscape-cli --home /home/riskscape function list
```

# Development

Significant changes should be mentioned in `CHANGELOG.md` as part of
development. Add things to an "Unreleased" section at the top of the
file.

## Release Procedure

### Prerequisites

Before proceeding with the release process please check that
the RiskScape codebase is stable and is ready for release. In particular:
- CHANGELOG.md is accurate, makes sense to users, and has the correct version heading/date.
- the license `riskscape --license` has the current year in the copyright. Check in the
docs license page as well.
- the version links in docs/downloads.md have been updated (the links are placeholders
that will point to the new release once we've uploaded it). Make sure to check the version for
riskscape-geotools-patches.jar as well

### Building the release

To create a new version of the Riskscape Engine software, update the
version number in `VERSION` and rename the "Unreleased" section of
`CHANGELOG.md` accordingly.

Then, tag and sign a new version:

```
vim VERSION # remove -dev suffix
read VERSION < VERSION
git add VERSION && git commit -m "build: Remove dev suffix for ${VERSION} build"
git tag --sign "${VERSION}" --message "Release ${VERSION}"
git push --tags
# bump version, typically this is the minor version, e.g. 1.3.0 -> 1.4.0'
# Don't forget to add the -dev suffix!
vim VERSION
grep '\-dev$' VERSION \
	&& read VERSION < VERSION \
	&& git add VERSION \
	&& git commit -m "build: Bump version to ${VERSION}"
```

Assuming the tests pass, CI will then publish a new docker image as
`gitlab.catalyst.net.nz:4567/riskscape/riskscape/cli:${VERSION}`.

### Uploading the release

Now follow the `../riskscape-opscode/releases/README.md` instructions to
update the new release.

### Follow-up tasks

Once released, remember to update any other repositories that rely on
the RiskScape snapshot packages to build. Currently these are:
- eqc (RISKSCAPE_VERSION in .gitlab-ci.yml)
- riskscape-platform (riskscapeVersion in plugin/build.gradle)

## Documentation

Refer [docs README](./docs/README.md).

## Testing

### Testing PostGIS

To fire up a PostGIS database, use:

```
bin/docker-postgis.sh start
```

Then use the following to access it:

```
export PGPASSWORD=riskscape
postgis://riskscape@localhost:55432/riskscape
```
