/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.typeset;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.typeset.CanonicalType;
import nz.org.riskscape.engine.typeset.LinkedType;
import nz.org.riskscape.engine.typeset.MissingTypeException;
import nz.org.riskscape.engine.typeset.TypeExistsException;

public class TypeSet {
    public static final TypeSet GLOBAL_TYPE_SET = new TypeSet();
    protected Map<String, CanonicalType> set = Maps.newHashMap();

    public CanonicalType add(@NonNull String id, @NonNull Type type) throws TypeExistsException {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (this.set.containsKey(id)) {
            throw new TypeExistsException(id);
        }
        CanonicalType ct = new CanonicalType(id, type){

            @Override
            public TypeSet getTypeSet() {
                return TypeSet.this;
            }
        };
        this.set.put(id, ct);
        return ct;
    }

    public LinkedType getLinkedType(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        return new LinkedType(this, id);
    }

    public Optional<CanonicalType> get(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        return Optional.ofNullable(this.set.get(id));
    }

    public CanonicalType getRequired(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        return Optional.ofNullable(this.set.get(id)).orElseThrow(() -> new MissingTypeException(id));
    }

    public Set<CanonicalType> getAll() {
        return Sets.newHashSet(this.set.values());
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }
}

