/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.WrappingType;

public class WithinSet
implements WrappingType {
    public static final Joiner JOINER = Joiner.on((String)", ");
    private final Set<?> objects;
    private final Type underlyingType;

    public WithinSet(Type underlyingType, Object ... objects) {
        this(underlyingType, Arrays.asList(objects));
    }

    public WithinSet(Type underlyingType, Collection<?> objects) {
        if (objects.isEmpty()) {
            throw new IllegalArgumentException("member set can not be empty");
        }
        this.underlyingType = underlyingType;
        try {
            this.objects = ImmutableSet.copyOf((Collection)objects.stream().map(m -> underlyingType.coerce(m)).collect(Collectors.toSet()));
        }
        catch (CoercionException ex) {
            throw new IllegalArgumentException("member set must conform to underlying type", ex);
        }
    }

    @Override
    public Object coerce(Object value) {
        Object coerced = this.underlyingType.coerce(value);
        if (!this.objects.contains(coerced)) {
            throw new CoercionException(value, (Type)this, "'%s' does not belong to set [%s]", value, this.allowedString());
        }
        return coerced;
    }

    @Override
    public Class<?> internalType() {
        return this.underlyingType.internalType();
    }

    public String allowedString() {
        return JOINER.join(this.objects);
    }

    public String toString() {
        return String.format("WithinSet(type=%s, allowed=[%s])", this.underlyingType, this.allowedString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof WithinSet) {
            WithinSet rhs = (WithinSet)obj;
            return rhs.underlyingType.equals(this.underlyingType) && rhs.objects.equals(this.objects);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.underlyingType, this.objects});
    }

    @Override
    public Type getUnderlyingType() {
        return this.underlyingType;
    }
}

