/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import com.google.common.collect.ImmutableMap;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.SimpleType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;

public class Value {
    private final Object value;
    private final Type type;

    public static Value of(Type type, Object rawValue) throws CoercionException {
        return new Value(type, rawValue);
    }

    public Value(Type type, Object rawValue) throws CoercionException {
        this.type = type;
        this.value = type.coerce(rawValue);
    }

    public String toString() {
        return String.format("%s:%s", this.type, this.value);
    }

    public Value toStruct() {
        Type unwrapped = this.type.getUnwrappedType();
        if (unwrapped instanceof Struct) {
            return new Value(unwrapped, this.value);
        }
        if (unwrapped instanceof SimpleType) {
            SimpleType simple = (SimpleType)unwrapped;
            return new Value(simple.asStruct(), ImmutableMap.of((Object)"value", (Object)this.value));
        }
        throw new RuntimeException(String.format("Can not represent %s as a struct - unknown type %s", this.value, unwrapped));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        Value other = (Value)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Value;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public Object getValue() {
        return this.value;
    }

    public Type getType() {
        return this.type;
    }
}

