/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import com.vividsolutions.jts.geom.Geometry;
import java.math.BigDecimal;
import java.util.Optional;
import nz.org.riskscape.engine.types.Anything;
import nz.org.riskscape.engine.types.Bool;
import nz.org.riskscape.engine.types.Date;
import nz.org.riskscape.engine.types.Decimal;
import nz.org.riskscape.engine.types.Floating;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Integer;
import nz.org.riskscape.engine.types.SimpleType;
import nz.org.riskscape.engine.types.Text;
import nz.org.riskscape.engine.types.Type;

public class Types {
    public static final Text TEXT = new Text();
    public static final Integer INTEGER = new Integer();
    public static final Floating FLOATING = new Floating();
    public static final Decimal DECIMAL = new Decimal();
    public static final Anything ANYTHING = new Anything();
    public static final Geom GEOMETRY = new Geom();
    public static final Bool BOOLEAN = new Bool();
    public static final Date DATE = new Date();

    public static Type fromJavaType(Class<?> javaType) {
        Type fromJavaTypeInternal = Types.fromJavaTypeInternal(javaType);
        if (fromJavaTypeInternal == null) {
            throw new RuntimeException("Unmapped type: " + javaType);
        }
        return fromJavaTypeInternal;
    }

    public static Optional<Type> fromJavaTypeOptional(Class<?> javaType) {
        return Optional.ofNullable(Types.fromJavaTypeInternal(javaType));
    }

    private static Type fromJavaTypeInternal(Class<?> javaType) {
        if (javaType.equals(java.lang.Integer.class) || javaType.equals(Long.class) || javaType.equals(Short.class) || javaType.equals(Byte.class)) {
            return INTEGER;
        }
        if (javaType.equals(Boolean.class) || javaType.equals(Boolean.TYPE)) {
            return BOOLEAN;
        }
        if (javaType.equals(String.class)) {
            return TEXT;
        }
        if (Geometry.class.isAssignableFrom(javaType)) {
            return GEOMETRY;
        }
        if (javaType.equals(BigDecimal.class)) {
            return DECIMAL;
        }
        if (javaType.equals(Double.class)) {
            return FLOATING;
        }
        if (javaType.equals(Float.class)) {
            return FLOATING;
        }
        if (java.util.Date.class.isAssignableFrom(javaType)) {
            return DATE;
        }
        return null;
    }

    public static Optional<Type> fromStrictJavaTypeOptional(Class<?> javaType) {
        SimpleType found = javaType.equals(Long.class) ? INTEGER : (javaType.equals(Boolean.class) ? BOOLEAN : (javaType.equals(String.class) ? TEXT : (Geometry.class.isAssignableFrom(javaType) ? GEOMETRY : (javaType.equals(BigDecimal.class) ? DECIMAL : (javaType.equals(Double.class) ? FLOATING : (java.util.Date.class.isAssignableFrom(javaType) ? DATE : null))))));
        return Optional.ofNullable(found);
    }
}

