/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.WrappingType;

public interface Type {
    public Object coerce(Object var1) throws CoercionException;

    public Class<?> internalType();

    default public boolean isNumeric() {
        return Number.class.isAssignableFrom(this.internalType());
    }

    default public void checkForNull(Object value) {
        if (value == null) {
            throw new CoercionException(value, this, "null is not a valid value for type " + this.toString(), new Object[0]);
        }
    }

    default public Type getUnwrappedType() {
        if (this instanceof WrappingType) {
            return ((WrappingType)this).getUnderlyingType().getUnwrappedType();
        }
        return this;
    }

    default public boolean isWrapped() {
        return this != this.getUnwrappedType();
    }

    public Struct asStruct();

    public int estimateSize(Object var1);

    public void toBytes(DataOutputStream var1, Object var2) throws IOException;

    public Object fromBytes(DataInputStream var1) throws IOException;

    default public boolean isNullable() {
        return false;
    }

    default public String toString(Object value) {
        return Objects.toString(value);
    }
}

