/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Type;

public class Struct
implements Type {
    private final ImmutableList<StructMember> members;
    private final ImmutableMap<String, StructMember> membersMap;

    public static Struct of() {
        return new StructBuilder().build();
    }

    public static Struct of(String key, Type type) {
        return new StructBuilder().add(key, type).build();
    }

    public static Struct of(String k0, Type t0, String k1, Type t1) {
        return new StructBuilder().add(k0, t0).add(k1, t1).build();
    }

    public static Struct of(String k0, Type t0, String k1, Type t1, String k2, Type t2) {
        return new StructBuilder().add(k0, t0).add(k1, t1).add(k2, t2).build();
    }

    public static Struct of(String k0, Type t0, String k1, Type t1, String k2, Type t2, String k3, Type t3) {
        return new StructBuilder().add(k0, t0).add(k1, t1).add(k2, t2).add(k3, t3).build();
    }

    public static StructBuilder builder() {
        return new StructBuilder();
    }

    public List<String> getMemberKeys() {
        return ImmutableList.sortedCopyOf((Iterable)this.membersMap.keySet());
    }

    public Struct(ImmutableList<StructMember> members) {
        this.members = members;
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)members.size());
        for (StructMember member : members) {
            builder.put((Object)member.key, (Object)member);
            if (member.owner != null) {
                throw new RuntimeException("Members can not be reused, create a new one");
            }
            member.owner = this;
        }
        this.membersMap = builder.build();
    }

    @Override
    public Object coerce(Object value) {
        if (value instanceof Tuple && ((Tuple)value).getStruct() == this) {
            return value;
        }
        if (value instanceof Map) {
            Map sourceTuple = (Map)value;
            return Tuple.coerce(this, sourceTuple, EnumSet.of(Tuple.CoerceOptions.SURPLUS_IGNORED));
        }
        if (this.members.size() == 1) {
            StructMember m = (StructMember)this.members.get(0);
            HashMap map = Maps.newHashMap();
            map.put(m.key, m.type.coerce(value));
            return Tuple.coerce(this, map, EnumSet.of(Tuple.CoerceOptions.MISSING_IGNORED));
        }
        throw new CoercionException(value, this);
    }

    @Override
    public Class<?> internalType() {
        return Map.class;
    }

    public static ImmutableMap.Builder<String, Object> mapBuilder() {
        return ImmutableMap.builder();
    }

    public Struct build() {
        return this;
    }

    public String toString() {
        List memberStrings = this.members.stream().map(se -> String.format("%s=>%s", se.key, se.type)).collect(Collectors.toList());
        String joined = Joiner.on((String)", ").join(memberStrings);
        return "{" + joined + "}";
    }

    public Optional<StructMember> getMember(String key) {
        return Optional.of(this.membersMap.get((Object)key));
    }

    public StructMember getEntry(String key) {
        return (StructMember)this.membersMap.get((Object)key);
    }

    public Struct parent(String asKey) {
        return Struct.of(asKey, this).build();
    }

    public Struct add(String asKey, Type otherType) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int count = 0;
        for (StructMember member : this.members) {
            builder.add((Object)new StructMember(member.getKey(), member.getType(), count));
            ++count;
        }
        builder.add((Object)new StructMember(asKey, otherType, count));
        return new Struct((ImmutableList<StructMember>)builder.build());
    }

    public Struct replace(String key, Type newType) {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean replaced = false;
        int count = 0;
        for (StructMember member : this.members) {
            Type type;
            if (member.getKey().equals(key)) {
                type = newType;
                replaced = true;
            } else {
                type = member.getType();
            }
            builder.add((Object)new StructMember(member.getKey(), type, count));
            ++count;
        }
        if (!replaced) {
            throw new IllegalArgumentException(String.format("This struct does not contain a member with key %s, has %s", key, this.members));
        }
        return new Struct((ImmutableList<StructMember>)builder.build());
    }

    public Struct and(String newKey, Type newType) {
        return this.add(newKey, newType);
    }

    @Override
    public Struct asStruct() {
        return this;
    }

    public int size() {
        return this.members.size();
    }

    public boolean contains(StructMember entry) {
        return this.members.contains((Object)entry);
    }

    public boolean isEquivalent(Struct rhs) {
        return this.members.stream().map(se -> Arrays.asList(se.key, se.type)).collect(Collectors.toSet()).equals(rhs.members.stream().map(se -> Arrays.asList(se.key, se.type)).collect(Collectors.toSet()));
    }

    public boolean isSupersetOf(Struct rhs) {
        throw new RuntimeException("not yet implemented");
    }

    public boolean hasMember(String key) {
        return this.membersMap.containsKey((Object)key);
    }

    public int hashCode() {
        return this.members.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof Struct) {
            Struct rhsStruct = (Struct)rhs;
            return this.members.equals(rhsStruct.members);
        }
        return false;
    }

    @Override
    public int estimateSize(Object entry) {
        if (entry instanceof Tuple) {
            Tuple tuple = (Tuple)entry;
            return tuple.estimateSize();
        }
        return 0;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        Tuple value = (Tuple)toWrite;
        if (value.getStruct() == this) {
            for (StructMember member : this.members) {
                member.type.toBytes(os, value.fetch(member));
            }
        } else {
            throw new IllegalArgumentException("toWrite is not a struct of this type");
        }
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        Tuple tuple = new Tuple(this);
        for (StructMember member : this.members) {
            Object read = member.type.fromBytes(in);
            tuple.set(member, read);
        }
        return tuple;
    }

    public ImmutableList<StructMember> getMembers() {
        return this.members;
    }

    public static class StructBuilder {
        private final List<StructMember> pairs;

        public StructBuilder() {
            this.pairs = Lists.newArrayList();
        }

        public StructBuilder(int expectedSize) {
            this.pairs = Lists.newArrayListWithCapacity((int)expectedSize);
        }

        public StructBuilder and(String key, Type type) {
            return this.add(key, type);
        }

        public StructBuilder add(String key, Type type) {
            this.pairs.add(new StructMember(key, type, this.pairs.size()));
            return this;
        }

        public Struct build() {
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.pairs.size());
            for (StructMember member : this.pairs) {
                builder.add((Object)member.clone());
            }
            return new Struct((ImmutableList<StructMember>)builder.build());
        }

        public boolean isEmpty() {
            return this.pairs.isEmpty();
        }

        public int size() {
            return this.pairs.size();
        }
    }

    public static class StructMember {
        @NonNull
        final String key;
        @NonNull
        final Type type;
        final int index;
        Struct owner;

        public StructMember clone() {
            return new StructMember(this.key, this.type, this.index);
        }

        @NonNull
        public String getKey() {
            return this.key;
        }

        @NonNull
        public Type getType() {
            return this.type;
        }

        public int getIndex() {
            return this.index;
        }

        public Struct getOwner() {
            return this.owner;
        }

        public void setOwner(Struct owner) {
            this.owner = owner;
        }

        public StructMember(@NonNull String key, @NonNull Type type, int index) {
            if (key == null) {
                throw new NullPointerException("key");
            }
            if (type == null) {
                throw new NullPointerException("type");
            }
            this.key = key;
            this.type = type;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StructMember)) {
                return false;
            }
            StructMember other = (StructMember)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            return this.getIndex() == other.getIndex();
        }

        protected boolean canEqual(Object other) {
            return other instanceof StructMember;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            result = result * 59 + this.getIndex();
            return result;
        }

        public String toString() {
            return "Struct.StructMember(key=" + this.getKey() + ", type=" + this.getType() + ", index=" + this.getIndex() + ")";
        }
    }
}

