/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Optional;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.WrappingType;

public class Nullable
implements Type,
WrappingType {
    public static final Nullable TEXT = new Nullable(Types.TEXT);
    public static final Nullable BOOLEAN = new Nullable(Types.BOOLEAN);
    public static final Nullable INTEGER = new Nullable(Types.INTEGER);
    public static final Nullable FLOATING = new Nullable(Types.FLOATING);
    public static final Nullable DECIMAL = new Nullable(Types.DECIMAL);
    public static final Nullable ANYTHING = new Nullable(Types.ANYTHING);
    public static final Nullable DATE = new Nullable(Types.DATE);
    private Type wrapped;

    public static Nullable of(Type wrapped) {
        if (wrapped instanceof Nullable) {
            return (Nullable)wrapped;
        }
        if (wrapped == Types.TEXT) {
            return TEXT;
        }
        if (wrapped == Types.BOOLEAN) {
            return BOOLEAN;
        }
        if (wrapped == Types.INTEGER) {
            return INTEGER;
        }
        if (wrapped == Types.FLOATING) {
            return FLOATING;
        }
        if (wrapped == Types.DECIMAL) {
            return DECIMAL;
        }
        if (wrapped == Types.DATE) {
            return DATE;
        }
        return new Nullable(wrapped);
    }

    protected Nullable(Type wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Optional) {
            Optional opt = (Optional)value;
            if (opt.isPresent()) {
                return this.wrapped.coerce(opt.get());
            }
            return null;
        }
        return this.wrapped.coerce(value);
    }

    @Override
    public Class<?> internalType() {
        return this.wrapped.internalType();
    }

    @Override
    public Struct asStruct() {
        return this.wrapped.asStruct();
    }

    @Override
    public Type getUnderlyingType() {
        return this.wrapped;
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs instanceof Nullable) {
            Nullable rhsNullable = (Nullable)rhs;
            return rhsNullable.wrapped.equals(this.wrapped);
        }
        return false;
    }

    public String toString() {
        return "Nullable[" + this.wrapped.toString() + "]";
    }

    @Override
    public int estimateSize(Object entry) {
        return 1 + this.wrapped.estimateSize(entry);
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        if (toWrite == null) {
            os.writeBoolean(false);
        } else {
            os.writeBoolean(true);
            this.wrapped.toBytes(os, toWrite);
        }
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        boolean present = in.readBoolean();
        if (present) {
            return this.wrapped.fromBytes(in);
        }
        return null;
    }

    @Override
    public boolean isNullable() {
        return true;
    }
}

