/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import com.google.common.collect.Lists;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;

public class List
implements Type {
    private final Type memberType;

    @Override
    public Object coerce(Object value) throws CoercionException {
        if (value.getClass().isArray()) {
            java.util.List<Object> coerced = value.getClass() == float[].class ? Floats.asList((float[])((float[])value)) : (value.getClass() == double[].class ? Doubles.asList((double[])((double[])value)) : (value.getClass() == byte[].class ? Bytes.asList((byte[])((byte[])value)) : (value.getClass() == short[].class ? Shorts.asList((short[])((short[])value)) : (value.getClass() == char[].class ? Chars.asList((char[])((char[])value)) : (value.getClass() == int[].class ? Ints.asList((int[])((int[])value)) : (value.getClass() == long[].class ? Longs.asList((long[])((long[])value)) : Arrays.asList((Object[])value)))))));
            coerced = Lists.newArrayList((Iterable)coerced);
            coerced.replaceAll(raw -> this.memberType.coerce(raw));
            return coerced;
        }
        if (value instanceof java.util.List) {
            java.util.List asList = (java.util.List)value;
            asList.replaceAll(raw -> this.memberType.coerce(raw));
            return asList;
        }
        throw new CoercionException(value, this);
    }

    @Override
    public Class<?> internalType() {
        return java.util.List.class;
    }

    @Override
    public Struct asStruct() {
        return Struct.of("value", this);
    }

    public Type getMemberType() {
        return this.memberType;
    }

    @Override
    public int estimateSize(Object entry) {
        int total = 0;
        java.util.List asList = (java.util.List)entry;
        for (Object object : asList) {
            total += this.memberType.estimateSize(object);
        }
        return total;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        java.util.List listToWrite = (java.util.List)toWrite;
        int members = listToWrite.size();
        os.writeInt(members);
        for (Object object : listToWrite) {
            this.memberType.toBytes(os, object);
        }
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        Object[] beingRead = new Object[in.readInt()];
        for (int i = 0; i < beingRead.length; ++i) {
            beingRead[i] = this.memberType.fromBytes(in);
        }
        return Arrays.asList(beingRead);
    }

    public String toString() {
        return String.format("List[%s]", this.memberType);
    }

    public List(Type memberType) {
        this.memberType = memberType;
    }
}

