/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Rangeable;
import nz.org.riskscape.engine.types.SimpleType;
import nz.org.riskscape.engine.types.Type;

public class Integer
extends SimpleType
implements Rangeable {
    @Override
    public Object coerce(Object value) {
        this.checkForNull(value);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return new BigDecimal((String)value).longValue();
            }
            catch (NumberFormatException ex) {
                throw new CoercionException(value, (Type)this, "", new Object[0]);
            }
        }
        throw new CoercionException(value, this);
    }

    @Override
    public Class<?> internalType() {
        return Long.class;
    }

    @Override
    public int estimateSize(Object entry) {
        return 4;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        os.writeLong(((Number)toWrite).longValue());
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        return in.readLong();
    }
}

