/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.InputStreamInStream;
import com.vividsolutions.jts.io.OutStream;
import com.vividsolutions.jts.io.OutputStreamOutStream;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.SimpleType;
import nz.org.riskscape.engine.types.Type;

public class Geom
extends SimpleType {
    public static final WKTReader READER = new WKTReader();
    public static final WKBReader WKB_READER = new WKBReader();
    public static final WKBWriter WKB_WRITER = new WKBWriter();
    private static final int HOUSEKEEPING_BYTES = 3;
    private static final int NUM_DIMENSIONS = 2;

    @Override
    public Object coerce(Object value) throws CoercionException {
        this.checkForNull(value);
        if (value instanceof String) {
            try {
                return READER.read((String)value);
            }
            catch (ParseException e) {
                throw new CoercionException(value, (Type)this, "Could not parse well known text", new Object[]{e});
            }
        }
        if (value instanceof Geometry) {
            return value;
        }
        throw new CoercionException(value, (Type)this, "Can not coerce object of type %s", value.getClass());
    }

    @Override
    public Class<?> internalType() {
        return Geometry.class;
    }

    @Override
    public int estimateSize(Object entry) {
        Geometry geom = (Geometry)entry;
        return 3 + geom.getNumPoints() * 2 * 8;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        Geometry geometry = (Geometry)toWrite;
        os.writeInt(geometry.getSRID());
        WKB_WRITER.write(geometry, (OutStream)new OutputStreamOutStream((OutputStream)os));
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        try {
            int srid = in.readInt();
            Geometry geometry = WKB_READER.read((InStream)new InputStreamInStream((InputStream)in));
            geometry.setSRID(srid);
            return geometry;
        }
        catch (ParseException e) {
            throw new IOException("Failed to parse bytes from underlying byte stream", e);
        }
    }

    @Override
    public String toString(Object value) {
        if (value instanceof Geometry) {
            Geometry geometry = (Geometry)value;
            return String.format("%s[%d pts]", geometry.getClass().getSimpleName(), geometry.getCoordinates().length);
        }
        return super.toString(value);
    }
}

