/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;

public class Enumeration
implements Type {
    private final boolean oneBased;
    private final String[] values;
    private final String[] lowerCasedValues;

    public static Enumeration zeroBased(String ... values) {
        return Enumeration.fromValues(false, values);
    }

    public static Enumeration oneBased(String ... values) {
        return Enumeration.fromValues(true, values);
    }

    private static Enumeration fromValues(boolean oneBased, String ... values) {
        String[] adjustedValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            String allowedValue = values[i];
            if (allowedValue == null) continue;
            String lowered = values[i].toLowerCase();
            for (int j = 0; j < i; ++j) {
                String alreadyIn = adjustedValues[j];
                if (alreadyIn == null || !alreadyIn.equals(lowered)) continue;
                throw new IllegalArgumentException("Enum value is in values more than once - " + lowered);
            }
            adjustedValues[i] = lowered;
        }
        return new Enumeration(oneBased, values, adjustedValues);
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        int offset;
        String strValue;
        this.checkForNull(value);
        if (value instanceof String && (strValue = ((String)value).trim()).matches("^[0-9]+$")) {
            try {
                value = Integer.valueOf(strValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int n = offset = this.oneBased ? -1 : 0;
        if (value instanceof String) {
            for (int i = 0; i < this.values.length; ++i) {
                if (!((String)value).toLowerCase().equals(this.lowerCasedValues[i])) continue;
                return this.values[i];
            }
            StringBuilder formatted = new StringBuilder();
            for (int i = 0; i < this.values.length; ++i) {
                String string;
                if (formatted.length() > 0) {
                    formatted.append(", ");
                }
                if ((string = this.values[i]) == null) continue;
                formatted.append(String.format("%d:%s", i, string));
            }
            throw new CoercionException(value, (Type)this, "Given string '%s' does not belong to this enumeration's set of values (%s)", value, formatted);
        }
        if (value instanceof Number) {
            int intValue = ((Number)value).intValue();
            int offsetValue = intValue + offset;
            if (offsetValue < 0 || offsetValue >= this.values.length) {
                throw new CoercionException(value, (Type)this, "%d is out of range (%d <= x < %d)", value, 0 - offset, this.values.length - offset);
            }
            String lookedUpValue = this.values[offsetValue];
            if (lookedUpValue == null) {
                throw new CoercionException(value, (Type)this, "%d maps to a gap in this enum", value);
            }
            return lookedUpValue;
        }
        throw new CoercionException(value, (Type)this, "Value '%s' is not a number or a string", this);
    }

    @Override
    public Class<?> internalType() {
        return String.class;
    }

    public String toString() {
        return String.format("Enumeration(values=%s)", Lists.newArrayList((Object[])this.values));
    }

    @Override
    public int estimateSize(Object entry) {
        return Types.INTEGER.estimateSize(entry);
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        if (!(toWrite instanceof Number)) {
            String stringToWrite = (String)toWrite;
            for (int i = 0; i < this.lowerCasedValues.length; ++i) {
                String fromSet = this.lowerCasedValues[i];
                if (fromSet == null || !fromSet.equals(stringToWrite.toLowerCase())) continue;
                os.writeInt(i + (this.oneBased ? 1 : 0));
                return;
            }
            throw new CoercionException((Object)stringToWrite, (Type)this, "Value is not in enum, can not write", new Object[0]);
        }
        os.writeInt(((Number)toWrite).intValue());
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        return this.coerce(in.readInt());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Enumeration) {
            Enumeration rhs = (Enumeration)obj;
            return rhs.oneBased == this.oneBased && Arrays.equals(rhs.values, this.values);
        }
        return false;
    }

    @Override
    public Struct asStruct() {
        return Struct.of("value", this);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.oneBased, this.values});
    }

    private Enumeration(boolean oneBased, String[] values, String[] lowerCasedValues) {
        this.oneBased = oneBased;
        this.values = values;
        this.lowerCasedValues = lowerCasedValues;
    }
}

