/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.types;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.SimpleType;
import nz.org.riskscape.engine.types.Type;

public class Bool
extends SimpleType
implements Type {
    @Override
    public Object coerce(Object value) throws CoercionException {
        this.checkForNull(value);
        if (value instanceof Boolean) {
            return value;
        }
        return Boolean.valueOf(value.toString());
    }

    @Override
    public Class<?> internalType() {
        return Boolean.class;
    }

    @Override
    public int estimateSize(Object entry) {
        return 1;
    }

    @Override
    public void toBytes(DataOutputStream os, Object toWrite) throws IOException {
        os.writeBoolean((Boolean)toWrite);
    }

    @Override
    public Object fromBytes(DataInputStream in) throws IOException {
        return in.readBoolean();
    }
}

