/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import nz.org.riskscape.engine.Tuple;

public interface TupleIterator
extends Iterator<Tuple>,
AutoCloseable {
    public static final TupleIterator EMPTY = new TupleIterator(){

        @Override
        public Tuple next() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    };

    public static TupleIterator wrapped(final @NonNull Iterator<Tuple> iterator, final @NonNull Optional<Runnable> onClose) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (onClose == null) {
            throw new NullPointerException("onClose");
        }
        return new TupleIterator(){

            @Override
            public void close() {
                onClose.ifPresent(Runnable::run);
            }

            @Override
            public Tuple next() {
                Tuple value = (Tuple)iterator.next();
                return value;
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }
        };
    }

    public static <T> TupleIterator wrappedAndMapped(final @NonNull Iterator<T> iterator, final @NonNull Function<T, Tuple> mapper) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper");
        }
        return new TupleIterator(){

            @Override
            public Tuple next() {
                return (Tuple)mapper.apply(iterator.next());
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }
        };
    }

    @Override
    default public void close() {
    }
}

