/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import java.util.Optional;
import lombok.NonNull;
import nz.org.riskscape.engine.types.Struct;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpatialMetadata {
    @NonNull
    private final CoordinateReferenceSystem crs;
    @NonNull
    private final Struct.StructMember geometryStructMember;
    @NonNull
    private final Optional<ReferencedEnvelope> bounds;

    public SpatialMetadata(CoordinateReferenceSystem crs, Struct.StructMember geometryStructMember) {
        this.crs = crs;
        this.geometryStructMember = geometryStructMember;
        this.bounds = Optional.empty();
    }

    public SpatialMetadata(@NonNull CoordinateReferenceSystem crs, @NonNull Struct.StructMember geometryStructMember, @NonNull Optional<ReferencedEnvelope> bounds) {
        if (crs == null) {
            throw new NullPointerException("crs");
        }
        if (geometryStructMember == null) {
            throw new NullPointerException("geometryStructMember");
        }
        if (bounds == null) {
            throw new NullPointerException("bounds");
        }
        this.crs = crs;
        this.geometryStructMember = geometryStructMember;
        this.bounds = bounds;
    }

    @NonNull
    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    @NonNull
    public Struct.StructMember getGeometryStructMember() {
        return this.geometryStructMember;
    }

    @NonNull
    public Optional<ReferencedEnvelope> getBounds() {
        return this.bounds;
    }
}

