/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import nz.org.riskscape.engine.ProblemSink;
import nz.org.riskscape.engine.ResultOrProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.projection.Projection;
import nz.org.riskscape.engine.relation.NamedRelation;
import nz.org.riskscape.engine.relation.SpatialMetadata;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.restriction.Restriction;
import nz.org.riskscape.engine.types.Struct;
import org.geotools.geometry.jts.ReferencedEnvelope;

public interface Relation {
    public Struct getType();

    public TupleIterator iterator();

    public ResultOrProblems<Relation> project(Projection var1);

    public ResultOrProblems<Relation> restrict(Restriction var1);

    default public Stream<Tuple> stream() {
        TupleIterator iterator = this.iterator();
        Spliterator<Tuple> spliterator = Spliterators.spliteratorUnknownSize(iterator, 1280);
        return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> {
            try {
                iterator.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to close underlying iterator", e);
            }
        });
    }

    default public Optional<SpatialMetadata> getSpatialMetadata() {
        return Optional.empty();
    }

    default public <T extends Relation> NamedRelation<T> as(String name) {
        return new NamedRelation<Relation>(name, this);
    }

    public Relation skipInvalid(ProblemSink var1);

    public String getSourceInformation();

    default public Optional<ReferencedEnvelope> calculateBounds() {
        return this.getSpatialMetadata().flatMap(sm -> {
            try (TupleIterator iterator = this.iterator();){
                if (!iterator.hasNext()) {
                    Optional optional = Optional.empty();
                    return optional;
                }
                Tuple tuple = (Tuple)iterator.next();
                Struct.StructMember geomMember = sm.getGeometryStructMember();
                Geometry geometry = (Geometry)tuple.fetch(geomMember);
                Envelope envelope = geometry.getEnvelopeInternal();
                while (iterator.hasNext()) {
                    tuple = (Tuple)iterator.next();
                    geometry = (Geometry)tuple.fetch(geomMember);
                    envelope.expandToInclude(geometry.getEnvelopeInternal());
                }
                Optional<ReferencedEnvelope> optional = Optional.of(new ReferencedEnvelope(envelope.getMinX(), envelope.getMaxX(), envelope.getMinY(), envelope.getMaxY(), sm.getCrs()));
                return optional;
            }
        });
    }
}

