/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.relation;

import lombok.NonNull;
import nz.org.riskscape.engine.relation.Relation;

public class NamedRelation<T extends Relation> {
    @NonNull
    private final String name;
    @NonNull
    private final T relation;

    public NamedRelation<T> alias(@NonNull String newName) {
        if (newName == null) {
            throw new NullPointerException("newName");
        }
        return new NamedRelation<T>(newName, this.relation);
    }

    public NamedRelation(@NonNull String name, @NonNull T relation) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (relation == null) {
            throw new NullPointerException("relation");
        }
        this.name = name;
        this.relation = relation;
    }

    public String toString() {
        return "NamedRelation(name=" + this.getName() + ", relation=" + this.getRelation() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NamedRelation)) {
            return false;
        }
        NamedRelation other = (NamedRelation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        T this$relation = this.getRelation();
        T other$relation = other.getRelation();
        return !(this$relation == null ? other$relation != null : !this$relation.equals(other$relation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NamedRelation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        T $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : $relation.hashCode());
        return result;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public T getRelation() {
        return this.relation;
    }
}

