/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.query;

import java.util.function.Supplier;
import lombok.NonNull;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Types;

public class TupleUtils {
    public static Struct.StructMember findGeometryMember(@NonNull Struct source, FindOption option) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        return TupleUtils.findGeometryMember(source, option, () -> new RiskscapeException(String.format("Failed to find geometry on %s according to option %s", new Object[]{source, option})));
    }

    public static Struct.StructMember findGeometryMember(@NonNull Struct source, @NonNull FindOption option, @NonNull Supplier<RuntimeException> failedHandler) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (option == null) {
            throw new NullPointerException("option");
        }
        if (failedHandler == null) {
            throw new NullPointerException("failedHandler");
        }
        Struct.StructMember found = null;
        for (Struct.StructMember member : source.getMembers()) {
            if (!member.getType().getUnwrappedType().equals(Types.GEOMETRY)) continue;
            if (found == null) {
                found = member;
                continue;
            }
            if (option == FindOption.ONE_REQUIRED) {
                throw failedHandler.get();
            }
            return found;
        }
        if (found == null && option != FindOption.OPTIONAL) {
            throw failedHandler.get();
        }
        return found;
    }

    public static Struct.StructMember findRequiredGeometryMember(Struct struct) {
        return TupleUtils.findGeometryMember(struct, FindOption.ONE_REQUIRED, () -> new RiskscapeException("No single geometry member found on " + struct));
    }

    public static enum FindOption {
        ONE_REQUIRED,
        ANY_REQUIRED,
        OPTIONAL;

    }
}

