/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.projection;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.relation.SpatialMetadata;
import nz.org.riskscape.engine.types.Struct;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public interface Projector
extends Function<Tuple, Tuple> {
    public static String join(List<Struct.StructMember> members) {
        return members.stream().map(Struct.StructMember::getKey).collect(Collectors.joining("."));
    }

    public static Map<List<Struct.StructMember>, List<Struct.StructMember>> identityMapping(Struct struct) {
        return struct.getMembers().stream().collect(Collectors.toMap(m -> Arrays.asList(m), m -> Arrays.asList(m)));
    }

    public Struct getProjectedType();

    public Struct getSourceType();

    default public Map<List<Struct.StructMember>, List<Struct.StructMember>> getDirectMapping() {
        return Collections.emptyMap();
    }

    default public Optional<Function<SpatialMetadata, SpatialMetadata>> getSpatialMetadataMapper() {
        return Optional.of(source -> {
            if (source != null) {
                CoordinateReferenceSystem crs = source.getCrs();
                return Optional.ofNullable(TupleUtils.findGeometryMember(this.getProjectedType(), TupleUtils.FindOption.OPTIONAL)).map(sm -> new SpatialMetadata(crs, (Struct.StructMember)sm)).orElse(null);
            }
            return null;
        });
    }

    default public Map<String, String> getDirectMappingStrings() {
        return this.getDirectMapping().entrySet().stream().collect(Collectors.toMap(e -> Projector.join((List)e.getKey()), e -> Projector.join((List)e.getValue())));
    }
}

