/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.projection;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import nz.org.riskscape.engine.ResultOrProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.relation.SpatialMetadata;
import nz.org.riskscape.engine.types.Struct;

public interface Projection {
    public static final Projection IDENTITY = new Projection(){

        public String toString() {
            return "Identity";
        }

        @Override
        public ResultOrProblems<Struct> projectType(Struct source) {
            return ResultOrProblems.of(source);
        }

        @Override
        public ResultOrProblems<Projector> getProjectionFunction(final Struct sourceType) {
            final Map<List<Struct.StructMember>, List<Struct.StructMember>> directMapping = Projector.identityMapping(sourceType);
            return ResultOrProblems.of(new Projector(){

                @Override
                public Tuple apply(Tuple t) {
                    return t;
                }

                @Override
                public Struct getProjectedType() {
                    return sourceType;
                }

                @Override
                public Struct getSourceType() {
                    return sourceType;
                }

                @Override
                public Map<List<Struct.StructMember>, List<Struct.StructMember>> getDirectMapping() {
                    return directMapping;
                }

                @Override
                public Optional<Function<SpatialMetadata, SpatialMetadata>> getSpatialMetadataMapper() {
                    return Optional.of(Function.identity());
                }
            });
        }
    };

    public ResultOrProblems<Struct> projectType(Struct var1);

    public ResultOrProblems<Projector> getProjectionFunction(Struct var1);
}

