/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import nz.org.riskscape.engine.Problem;
import nz.org.riskscape.engine.ResultOrProblems;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.typeset.IdentifiedType;
import nz.org.riskscape.engine.typeset.MissingTypeException;

public class JavaFunction
implements IdentifiedFunction {
    public static final Pattern ID_PATTERN = Pattern.compile("[\\w:_-]*");
    private final String id;
    private final String source;
    private final String description;
    private final List<Type> argumentTypes;
    private final Type returnType;
    private final Delegate delegate;

    public static JavaFunction withId(String id) {
        return new JavaFunction(id, null, id, Collections.emptyList(), Types.ANYTHING, x -> x);
    }

    public static JavaFunction withIdAndSource(String id, String source) {
        return new JavaFunction(id, source, id, Collections.emptyList(), Types.ANYTHING, x -> x);
    }

    @Override
    public Object call(List<Object> args) {
        return this.returnType.coerce(this.delegate.apply(args));
    }

    @Override
    public ResultOrProblems<Boolean> validate() {
        List<Problem> problems = this.validateFunctionAttributes();
        if (problems.isEmpty()) {
            problems = this.delegate.validate();
        }
        if (!problems.isEmpty()) {
            Problem problem;
            String sourceString = "";
            if (this.getSource() != null) {
                sourceString = String.format(". Source: %s", this.getSource());
            }
            return ResultOrProblems.of(Boolean.valueOf(!(problem = Problem.composite(problems, "Function '%s' has problems%s", this.getId(), sourceString)).isError()), Lists.newArrayList((Object[])new Problem[]{problem}));
        }
        return ResultOrProblems.of(true);
    }

    private List<Problem> validateFunctionAttributes() {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (!ID_PATTERN.matcher(this.id).matches()) {
            problems.add(Problem.error("ID '%s' is not allowed. ID's may only contain letters, digits, ':', '-' and '_' characters", this.id));
        }
        this.validateTypeExists(this.getReturnType(), "Return type '%s' does not exist. Refer to 'riskscape type list' for available types", p -> problems.add((Problem)p));
        for (Type argumentType : this.getArgumentTypes()) {
            this.validateTypeExists(argumentType, "Input type '%s' does not exist. Refer to 'riskscape type list' for available types", p -> problems.add((Problem)p));
        }
        return problems;
    }

    private void validateTypeExists(Type type, String messageFormat, Consumer<Problem> problems) {
        if (type instanceof IdentifiedType) {
            IdentifiedType identified = (IdentifiedType)type;
            try {
                identified.getUnderlyingType();
            }
            catch (MissingTypeException e) {
                problems.accept(Problem.error(messageFormat, identified.getId()));
            }
        }
    }

    public JavaFunction withDescription(String newDescription) {
        return new JavaFunction(this.id, this.source, newDescription, this.argumentTypes, this.returnType, this.delegate);
    }

    public JavaFunction withSignature(List<Type> newArgumentTypes, Type newReturnType) {
        return new JavaFunction(this.id, this.source, this.description, newArgumentTypes, newReturnType, this.delegate);
    }

    public JavaFunction withArgumentTypes(Type ... newArgumentTypes) {
        return new JavaFunction(this.id, this.source, this.description, Arrays.asList(newArgumentTypes), this.returnType, this.delegate);
    }

    public JavaFunction withArgumentTypes(List<Type> newArgumentTypes) {
        return new JavaFunction(this.id, this.source, this.description, newArgumentTypes, this.returnType, this.delegate);
    }

    public JavaFunction withReturnType(Type newReturnType) {
        return new JavaFunction(this.id, this.source, this.description, this.argumentTypes, newReturnType, this.delegate);
    }

    public JavaFunction calling(Delegate newDelegate) {
        return new JavaFunction(this.id, this.source, this.description, this.argumentTypes, this.returnType, newDelegate);
    }

    public JavaFunction(String id, String source, String description, List<Type> argumentTypes, Type returnType, Delegate delegate) {
        this.id = id;
        this.source = source;
        this.description = description;
        this.argumentTypes = argumentTypes;
        this.returnType = returnType;
        this.delegate = delegate;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    protected Delegate getDelegate() {
        return this.delegate;
    }

    public static interface Delegate
    extends Function<List<Object>, Object> {
        @Override
        public Object apply(List<Object> var1);

        default public List<Problem> validate() {
            return Collections.emptyList();
        }
    }
}

