/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import com.google.common.collect.ImmutableList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import nz.org.riskscape.engine.NoSuchMemberException;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;

public class Tuple
extends AbstractMap<String, Object> {
    private Struct struct;
    private Object[] entries;

    public static Tuple of(Struct type) {
        return new Tuple(type);
    }

    public static Tuple of(Struct type, String key, Object value) {
        return new Tuple(type).set(key, value);
    }

    public static Tuple of(Struct type, String key1, Object value1, String key2, Object value2) {
        return new Tuple(type).set(key1, value1).set(key2, value2);
    }

    public static Tuple ofValues(Struct type, Object ... values) {
        int size = type.getMembers().size();
        if (values.length == size) {
            Object[] dest = new Object[size];
            System.arraycopy(values, 0, dest, 0, size);
            return new Tuple(type, dest);
        }
        Tuple tuple = new Tuple(type);
        for (int i = 0; i < values.length; ++i) {
            tuple.set((Struct.StructMember)type.getMembers().get(i), values[i]);
        }
        return tuple;
    }

    public static Tuple coerce(Struct type, Map<?, ?> rawValues) {
        return Tuple.coerce(type, rawValues, EnumSet.noneOf(CoerceOptions.class));
    }

    public static Tuple coerce(Struct type, Map<?, ?> rawValues, EnumSet<CoerceOptions> options) {
        Tuple tuple = new Tuple(type);
        rawValues.entrySet().stream().forEach((? super T entry) -> {
            Struct.StructMember structMember = type.getEntry((String)entry.getKey());
            if (structMember == null) {
                if (!options.contains((Object)CoerceOptions.SURPLUS_IGNORED)) {
                    throw new NoSuchMemberException(type, (String)entry.getKey());
                }
            } else {
                tuple.set(structMember, structMember.getType().coerce(entry.getValue()));
            }
        });
        if (!options.contains((Object)CoerceOptions.MISSING_IGNORED) && tuple.hasRequiredNulls()) {
            ArrayList<String> missing = new ArrayList<String>();
            for (Struct.StructMember member : tuple.struct.getMembers()) {
                if (tuple.fetch(member) != null || member.getType().isNullable()) continue;
                missing.add(member.getKey());
            }
            throw new CoercionException(rawValues, (Type)type, "Supplied map '%s' is missing required keys - %s", rawValues, missing);
        }
        return tuple;
    }

    public Tuple(Struct struct) {
        this.struct = struct;
        this.entries = new Object[struct.size()];
    }

    private Tuple(Struct struct, Object[] entries) {
        this.struct = struct;
        this.entries = entries;
    }

    public Tuple(Struct struct, Map<String, String> values) {
        this(struct);
        values.entrySet().forEach((? super T entry) -> this.set((String)entry.getKey(), entry.getValue()));
    }

    public Tuple set(@NonNull String key, Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.entries[this.find((String)key).getIndex()] = value;
        return this;
    }

    public Tuple set(@NonNull Struct.StructMember key, Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.entries[this.checkOwner((Struct.StructMember)key).getIndex()] = value;
        return this;
    }

    public void remove(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.entries[this.find((String)key).getIndex()] = null;
    }

    public void remove(@NonNull Struct.StructMember key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.entries[this.checkOwner((Struct.StructMember)key).getIndex()] = null;
    }

    public <T> T fetch(String key) {
        return (T)this.entries[this.find(key).getIndex()];
    }

    public <T> T fetch(Struct.StructMember entry) {
        return (T)this.entries[this.checkOwner(entry).getIndex()];
    }

    public Tuple fetchChild(String key) {
        Struct.StructMember entry = this.find(key);
        if (Struct.class.isInstance(entry.getType().getUnwrappedType())) {
            return (Tuple)this.entries[entry.getIndex()];
        }
        throw new IllegalArgumentException(key + " is not a struct");
    }

    public Type getType(String key) {
        return this.find(key).getType();
    }

    private Struct.StructMember find(String key) {
        Struct.StructMember entry = this.struct.getEntry(key);
        if (entry == null) {
            throw new NoSuchMemberException(this.struct, key);
        }
        return entry;
    }

    @Override
    public Tuple clone() {
        Tuple clone = new Tuple(this.struct, Arrays.copyOf(this.entries, this.entries.length));
        for (int i = 0; i < clone.entries.length; ++i) {
            if (!(clone.entries[i] instanceof Tuple)) continue;
            Tuple child = (Tuple)clone.entries[i];
            clone.entries[i] = child.clone();
        }
        return clone;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entries);
    }

    @Override
    public boolean equals(Object rhs) {
        if (rhs instanceof Tuple) {
            Tuple rhsTuple = (Tuple)rhs;
            if (!rhsTuple.struct.equals(this.struct)) {
                return false;
            }
            for (int i = 0; i < this.entries.length; ++i) {
                if (Objects.equals(rhsTuple.entries[i], this.entries[i])) continue;
                return false;
            }
            return true;
        }
        if (rhs instanceof Map) {
            return super.equals(rhs);
        }
        return false;
    }

    private Struct.StructMember checkOwner(Struct.StructMember key) {
        if (this.struct != key.getOwner()) {
            throw new IllegalArgumentException(String.format("Given key (%s) not a member of our struct.  Expected %s but was %s", key.getKey(), System.identityHashCode(this.struct), System.identityHashCode(key.getOwner())));
        }
        return key;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.struct.getMembers().stream().filter(se -> this.entries[se.getIndex()] != null).map(se -> new AbstractMap.SimpleImmutableEntry<String, Object>(se.getKey(), this.entries[se.getIndex()])).collect(Collectors.toSet());
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    public boolean hasNulls() {
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] != null) continue;
            return true;
        }
        return false;
    }

    public boolean hasRequiredNulls() {
        ImmutableList<Struct.StructMember> members = this.struct.getMembers();
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] != null || ((Struct.StructMember)members.get(i)).getType().isNullable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Object get(Object key) {
        return this.fetch((String)key);
    }

    @Override
    public Object put(String key, Object value) {
        Object got = this.get(key);
        this.set(key, value);
        return got;
    }

    public int estimateSize() {
        int counter = 0;
        ImmutableList<Struct.StructMember> members = this.struct.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            Object entry = this.entries[i];
            if (entry == null) continue;
            Struct.StructMember member = (Struct.StructMember)members.get(i);
            counter += member.getType().estimateSize(entry);
        }
        return counter;
    }

    @Override
    public Object remove(Object key) {
        Object got = this.get(key);
        this.remove(key);
        return got;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        StringBuilder bldr = new StringBuilder("{");
        for (Struct.StructMember member : this.struct.getMembers()) {
            if (bldr.length() != 1) {
                bldr.append(", ");
            }
            bldr.append(member.getKey()).append("=").append(member.getType().toString(this.fetch(member)));
        }
        return bldr.append("}").toString();
    }

    public List<Object> getValues() {
        return Collections.unmodifiableList(Arrays.asList(this.entries));
    }

    public Object[] unsafeValues() {
        return this.entries;
    }

    public Struct getStruct() {
        return this.struct;
    }

    public static enum CoerceOptions {
        SURPLUS_IGNORED,
        MISSING_IGNORED;

    }
}

