/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import com.google.common.collect.Maps;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequenceFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import nz.org.riskscape.engine.GeometryReprojectionException;
import nz.org.riskscape.engine.UnknownSRIDException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class SRIDSet {
    public static final int UNSET_SRID = 0;
    private final Map<Integer, CoordinateReferenceSystem> registered = Maps.newHashMap();
    private PrecisionModel precisionModel = new PrecisionModel();
    private CoordinateSequenceFactory crsFactory = CoordinateArraySequenceFactory.instance();
    protected final Map<List<Integer>, MathTransform> cachedTransforms = Maps.newHashMap();
    protected final Map<Integer, GeometryFactory> cachedGeometryFactories = Maps.newHashMap();

    public CoordinateReferenceSystem get(int id) {
        CoordinateReferenceSystem remembered = this.registered.get(id);
        if (remembered == null) {
            throw new UnknownSRIDException(id);
        }
        return remembered;
    }

    public void put(int id, @NonNull CoordinateReferenceSystem crs) {
        if (crs == null) {
            throw new NullPointerException("crs");
        }
        this.registered.put(id, crs);
    }

    public int get(@NonNull FeatureSource<?, ?> fs) {
        if (fs == null) {
            throw new NullPointerException("fs");
        }
        return this.get(fs.getSchema());
    }

    public int get(@NonNull FeatureType type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        return this.get(type.getCoordinateReferenceSystem());
    }

    public int get(@NonNull CoordinateReferenceSystem crs) {
        if (crs == null) {
            throw new NullPointerException("crs");
        }
        Optional<Integer> srid = this.registered.entrySet().stream().filter(e -> CRS.equalsIgnoreMetadata((Object)crs, e.getValue())).findFirst().map(e -> (Integer)e.getKey());
        if (srid.isPresent()) {
            return srid.get();
        }
        int assigned = this.registered.size() + 1;
        this.registered.put(assigned, crs);
        return assigned;
    }

    public CoordinateReferenceSystem get(@NonNull Geometry geometry) {
        if (geometry == null) {
            throw new NullPointerException("geometry");
        }
        return this.get(geometry.getSRID());
    }

    public void remember(@NonNull SimpleFeatureSource fs) {
        if (fs == null) {
            throw new NullPointerException("fs");
        }
        this.get((FeatureSource<?, ?>)fs);
    }

    public Query queryWithHints(@NonNull Query query, @NonNull SimpleFeatureType schema) {
        if (query == null) {
            throw new NullPointerException("query");
        }
        if (schema == null) {
            throw new NullPointerException("schema");
        }
        Hints hints = new Hints();
        hints.put((Object)Hints.JTS_GEOMETRY_FACTORY, (Object)this.getGeometryFactory(schema.getCoordinateReferenceSystem()));
        Query newQuery = new Query();
        newQuery.setHints(hints);
        return DataUtilities.mixQueries((Query)query, (Query)newQuery, null);
    }

    public Geometry reproject(Geometry geom, int targetSrid) throws GeometryReprojectionException {
        if (geom.getSRID() == targetSrid) {
            return geom;
        }
        try {
            List<Integer> cacheKey = Arrays.asList(new Integer(geom.getSRID()), new Integer(targetSrid));
            MathTransform transform = this.cachedTransforms.computeIfAbsent(cacheKey, key -> {
                try {
                    return CRS.findMathTransform((CoordinateReferenceSystem)this.get(geom.getSRID()), (CoordinateReferenceSystem)this.get(targetSrid), (boolean)true);
                }
                catch (FactoryException e) {
                    throw new RuntimeException(e);
                }
            });
            Geometry transformed = JTS.transform((Geometry)geom, (MathTransform)transform);
            transformed.setSRID(targetSrid);
            return transformed;
        }
        catch (MismatchedDimensionException | TransformException ex) {
            throw new GeometryReprojectionException("Geometry could not be reprojected", geom, this.get(targetSrid), ex);
        }
    }

    public GeometryFactory getGeometryFactory(CoordinateReferenceSystem crs) {
        return this.cachedGeometryFactories.computeIfAbsent(this.get(crs), key -> new GeometryFactory(this.precisionModel, key.intValue(), this.crsFactory));
    }
}

