/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.NonNull;
import nz.org.riskscape.engine.Problem;
import nz.org.riskscape.engine.ResultComputationException;
import nz.org.riskscape.engine.Unchecked;
import nz.org.riskscape.engine.types.Anything;
import nz.org.riskscape.engine.types.Types;

public final class ResultOrProblems<T> {
    public static final List<Problem> NO_PROBLEMS = Collections.emptyList();
    private final T computedResult;
    private final List<Problem> problems;

    public static <T> ResultOrProblems<T> of(@NonNull T thing) {
        if (thing == null) {
            throw new NullPointerException("thing");
        }
        return new ResultOrProblems<T>(thing, NO_PROBLEMS);
    }

    public static <T> ResultOrProblems<T> of(@NonNull T thing, Problem ... problems) {
        if (thing == null) {
            throw new NullPointerException("thing");
        }
        return new ResultOrProblems<T>(thing, Arrays.asList(problems));
    }

    public static <T> ResultOrProblems<T> of(@NonNull T thing, List<Problem> withProblems) {
        if (thing == null) {
            throw new NullPointerException("thing");
        }
        return new ResultOrProblems<T>(thing, withProblems);
    }

    public static <T> ResultOrProblems<T> ofNullable(T thing, List<Problem> withProblems) {
        return new ResultOrProblems<T>(thing, withProblems);
    }

    public static <T> ResultOrProblems<T> failed(Problem ... withProblems) {
        return ResultOrProblems.failed(Arrays.asList(withProblems));
    }

    public static <T> ResultOrProblems<T> failed(List<Problem> withProblems) {
        return new ResultOrProblems<Object>(null, withProblems);
    }

    public static ResultOrProblems<Anything> unchecked(String message) {
        return new ResultOrProblems<Anything>(Types.ANYTHING, Arrays.asList(new Unchecked(message)));
    }

    public T get() {
        if (this.computedResult == null) {
            throw new ResultComputationException(this.getProblems());
        }
        return this.computedResult;
    }

    public <U> Optional<U> ifProblems(Function<List<Problem>, U> function) {
        if (this.problems.size() > 0) {
            return Optional.ofNullable(function.apply(this.problems));
        }
        return Optional.empty();
    }

    public boolean isPresent() {
        return this.computedResult != null;
    }

    public void ifPresent(Consumer<T> function) {
        if (this.computedResult != null) {
            function.accept(this.computedResult);
        }
    }

    public boolean hasProblems() {
        return this.problems.size() > 0;
    }

    public boolean hasProblems(Problem.Severity greaterThanEqualTo) {
        return this.problems.stream().filter(p -> p.getSeverity().ordinal() >= greaterThanEqualTo.ordinal()).findFirst().isPresent();
    }

    public <U> ResultOrProblems<U> flatMap(Function<? super T, ResultOrProblems<U>> mapper) {
        return this.flatMap((T t, List<Problem> p) -> {
            ResultOrProblems mapped = (ResultOrProblems)mapper.apply(t);
            ArrayList<Problem> combinedProblems = new ArrayList<Problem>(mapped.getProblems().size() + p.size());
            combinedProblems.addAll(this.problems);
            combinedProblems.addAll(mapped.problems);
            return ResultOrProblems.ofNullable(mapped.computedResult, combinedProblems);
        });
    }

    public <U> ResultOrProblems<U> flatMap(BiFunction<T, List<Problem>, ResultOrProblems<U>> mapper) {
        ResultOrProblems<U> mapped = null;
        if (this.computedResult == null) {
            return this;
        }
        mapped = mapper.apply(this.computedResult, this.problems);
        return mapped;
    }

    public <U> ResultOrProblems<U> map(Function<T, U> mapper) {
        T mapped = null;
        if (this.computedResult != null && (mapped = (T)mapper.apply(this.computedResult)) == null) {
            throw new NullPointerException("mapper must return a result, or use flatMap");
        }
        return new ResultOrProblems<Object>(mapped, this.problems);
    }

    public <U> ResultOrProblems<U> map(BiFunction<T, List<Problem>, U> mapper) {
        T mapped = null;
        if (this.computedResult != null && (mapped = (T)mapper.apply(this.computedResult, this.problems)) == null) {
            throw new NullPointerException("mapper must return a result, or use flatMap");
        }
        return new ResultOrProblems<Object>(mapped, this.problems);
    }

    public <U> ResultOrProblems<U> map(Function<T, U> mapper, Function<Problem, Problem> problemMapper) {
        T mapped = null;
        if (this.computedResult != null && (mapped = (T)mapper.apply(this.computedResult)) == null) {
            throw new NullPointerException("mapper must return a result, or use flatMap");
        }
        return new ResultOrProblems<Object>(mapped, this.problems.stream().map(problemMapper).collect(Collectors.toList()));
    }

    public T orElse(T otherThing) {
        if (this.computedResult == null) {
            return otherThing;
        }
        return this.computedResult;
    }

    public ResultOrProblems<T> withMoreProblems(Problem ... moreProblems) {
        return this.withMoreProblems(Arrays.asList(moreProblems));
    }

    public ResultOrProblems<T> withMoreProblems(Collection<Problem> moreProblems) {
        ArrayList newProblems = Lists.newArrayList();
        newProblems.addAll(this.problems);
        newProblems.addAll(moreProblems);
        return new ResultOrProblems<T>(this.computedResult, newProblems);
    }

    public <X extends Throwable> T orElseThrow(Function<List<Problem>, ? extends X> exceptionSupplier) throws X {
        if (this.computedResult != null) {
            return this.computedResult;
        }
        throw (Throwable)exceptionSupplier.apply(this.problems);
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.computedResult != null) {
            return this.computedResult;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public String toString() {
        if (this.computedResult != null) {
            return String.format("Of(%s)", this.computedResult);
        }
        return String.format("Failed(%s)", this.problems);
    }

    public boolean hasErrors() {
        return this.hasProblems(Problem.Severity.ERROR);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResultOrProblems)) {
            return false;
        }
        ResultOrProblems rhs = (ResultOrProblems)obj;
        return Objects.equals(this.computedResult, rhs.computedResult) && Objects.equals(this.problems, rhs.problems);
    }

    public int hashCode() {
        return Objects.hash(this.computedResult, this.problems);
    }

    public ResultOrProblems(T computedResult, List<Problem> problems) {
        this.computedResult = computedResult;
        this.problems = problems;
    }

    public List<Problem> getProblems() {
        return this.problems;
    }
}

