/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.stream.IntStream;

public class Problem {
    public final Severity severity;
    public final String message;
    public final Throwable error;
    public final List<? extends Problem> children;

    public static Problem info(String message, Object ... args) {
        return new Problem(Severity.INFO, String.format(message, args), null, Collections.emptyList());
    }

    public static Problem warning(String message, Object ... args) {
        return new Problem(Severity.WARNING, String.format(message, args), null, Collections.emptyList());
    }

    public static Problem warning(Throwable t, String message, Object ... args) {
        return new Problem(Severity.WARNING, String.format(message, args), t, Collections.emptyList());
    }

    public static Problem error(String message, Object ... args) {
        return new Problem(Severity.ERROR, String.format(message, args), null, Collections.emptyList());
    }

    public static Problem error(Throwable t, String message, Object ... args) {
        return new Problem(Severity.ERROR, String.format(message, args), t, Collections.emptyList());
    }

    public static Problem fatal(Throwable t, String message, Object ... args) {
        return new Problem(Severity.FATAL, String.format(message, args), t, Collections.emptyList());
    }

    public static Problem of(String message, Problem ... children) {
        return Problem.composite(Lists.newArrayList((Object[])children), message, new Object[0]);
    }

    public static Problem composite(List<? extends Problem> children, String message, Object ... args) {
        return Problem.composite(Problem.max(children), children, message, args);
    }

    public static Problem composite(Severity severity, List<? extends Problem> children, String message, Object ... args) {
        if (children.isEmpty()) {
            throw new IllegalArgumentException("Can not create a parent problem without children");
        }
        return new Problem(severity, String.format(message, args), null, children);
    }

    public Problem(Severity severity, String message) {
        this.severity = severity;
        this.message = message;
        this.error = null;
        this.children = Collections.emptyList();
    }

    public Problem(Severity severity, String message, Throwable error) {
        this.severity = severity;
        this.message = message;
        this.error = error;
        this.children = Collections.emptyList();
    }

    public static Severity max(Collection<? extends Problem> children) {
        return children.stream().map(p -> p.severity).max((s1, s2) -> s1.compareTo(s2)).orElse(Severity.INFO);
    }

    public static boolean hasErrors(Collection<? extends Problem> problems) {
        return Problem.max(problems).ordinal() >= Severity.ERROR.ordinal();
    }

    public boolean isError() {
        return this.severity.ordinal() >= Severity.ERROR.ordinal();
    }

    public boolean isFatal() {
        return this.severity == Severity.FATAL;
    }

    private boolean hasChildren() {
        return !this.children.isEmpty();
    }

    private void addChildren(String beginWith, Formatter f, int indentSize, int level) {
        for (Problem problem : this.children) {
            IntStream.rangeClosed(1, level * indentSize).forEach(ic -> f.format(" ", new Object[0]));
            f.format("%s- %s%n", beginWith, problem.message);
            if (!problem.hasChildren()) continue;
            problem.addChildren(beginWith, f, indentSize, level + 1);
        }
    }

    public String getOutputMessage() {
        return this.getOutputMessage("", 2);
    }

    public String getOutputMessage(String beginWith, int indentSize) {
        if (this.children.isEmpty()) {
            return String.format("%s%s%n", beginWith, this.getMessage());
        }
        StringBuilder sb = new StringBuilder();
        try (Formatter f = new Formatter(sb);){
            f.format("%s%s%n", beginWith, this.message, beginWith);
            this.addChildren(beginWith, f, indentSize, 1);
            String string = sb.toString();
            return string;
        }
    }

    public Problem(Severity severity, String message, Throwable error, List<? extends Problem> children) {
        this.severity = severity;
        this.message = message;
        this.error = error;
        this.children = children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Problem)) {
            return false;
        }
        Problem other = (Problem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Severity this$severity = this.getSeverity();
        Severity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Throwable this$error = this.getError();
        Throwable other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        List<? extends Problem> this$children = this.getChildren();
        List<? extends Problem> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Problem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Severity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Throwable $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        List<? extends Problem> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    public String toString() {
        return "Problem(severity=" + (Object)((Object)this.getSeverity()) + ", message=" + this.getMessage() + ", error=" + this.getError() + ", children=" + this.getChildren() + ")";
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getError() {
        return this.error;
    }

    public List<? extends Problem> getChildren() {
        return this.children;
    }

    public static enum Severity {
        INFO,
        WARNING,
        ERROR,
        FATAL;

    }
}

